/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceListCellRenderer;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceMenuStyle;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceTableCellHeaderRenderer;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceTableCellRenderer;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceTreeCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeCellRenderer;
import sun.swing.plaf.synth.DefaultSynthStyle;

class NiceStyleFactory
extends SynthStyleFactory {
    private static final String INIT_FLAG = "LAF_INIT";
    private SynthStyleFactory delegate;
    private final Set<SynthStyle> scaledStyles = new HashSet<SynthStyle>();

    NiceStyleFactory(SynthStyleFactory synthStyleFactory) {
        this.delegate = synthStyleFactory;
    }

    @Override
    public SynthStyle getStyle(final JComponent jComponent, Region region) {
        SynthStyle synthStyle = this.delegate.getStyle(jComponent, region);
        if (this.scaledStyles.add(synthStyle) && GUI.isLTAScalingEnabled() && synthStyle instanceof DefaultSynthStyle) {
            DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)synthStyle;
            Font font = defaultSynthStyle.getFont(jComponent, region, 0);
            defaultSynthStyle.setFont(font.deriveFont((float)((double)font.getSize() * GUI.getScaleFactor())));
        }
        if (Region.FILE_CHOOSER.equals(region)) {
            jComponent.addHierarchyListener(hierarchyEvent -> {
                JViewport jViewport;
                JList jList = NiceStyleFactory.findChildOfClass(jComponent, JList.class);
                if (jList != null) {
                    jList.setName("FileChooser.list");
                }
                if ((jViewport = NiceStyleFactory.findChildOfClass(jComponent, JViewport.class)) != null) {
                    jViewport.setName("FileChooser.viewport");
                }
            });
        }
        if (Region.MENU.equals(region) && jComponent instanceof JMenu) {
            if (synthStyle instanceof DefaultSynthStyle) {
                return new NiceMenuStyle((DefaultSynthStyle)synthStyle);
            }
        } else if (Region.LIST.equals(region) && jComponent instanceof JList) {
            this.initComponentIfNeeded(jComponent, synthStyle, (jComponent2, synthUI) -> {
                JList jList = (JList)jComponent;
                jList.setCellRenderer(new NiceListCellRenderer(jList.getCellRenderer()));
            });
        } else if (Region.TABLE.equals(region) && jComponent instanceof JTable) {
            this.initComponentIfNeeded(jComponent, synthStyle, (jComponent2, synthUI) -> {
                JTable jTable = (JTable)jComponent;
                NiceStyleFactory.installDefaultTableCellRenderer(jTable, Object.class);
                NiceStyleFactory.installDefaultTableCellRenderer(jTable, Boolean.class);
                NiceStyleFactory.installRolloverRepaintHandler(jComponent);
            });
        } else if (Region.TABLE_HEADER.equals(region) && jComponent instanceof JTableHeader) {
            this.initComponentIfNeeded(jComponent, synthStyle, (jComponent2, synthUI) -> {
                JTableHeader jTableHeader = (JTableHeader)jComponent;
                jTableHeader.setDefaultRenderer(new NiceTableCellHeaderRenderer(jTableHeader.getDefaultRenderer()));
            });
        } else if (Region.TREE.equals(region) && jComponent instanceof JTree) {
            this.initComponentIfNeeded(jComponent, synthStyle, (jComponent2, synthUI) -> {
                if (!NiceStyleFactory.installTreeCellRenderer((JTree)jComponent)) {
                    jComponent.addPropertyChangeListener("cellRenderer", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            try {
                                NiceStyleFactory.installTreeCellRenderer((JTree)jComponent);
                            }
                            finally {
                                SwingUtilities.invokeLater(() -> jComponent.removePropertyChangeListener("cellRenderer", this));
                            }
                        }
                    });
                }
            });
        }
        return synthStyle;
    }

    private void initComponentIfNeeded(JComponent jComponent, SynthStyle synthStyle, InitFunction initFunction) {
        if (jComponent.getClientProperty(INIT_FLAG) == null) {
            try {
                initFunction.init(jComponent, (SynthUI)((Object)UIManager.getUI(jComponent)));
            }
            finally {
                jComponent.putClientProperty(INIT_FLAG, true);
            }
        }
    }

    private static boolean installTreeCellRenderer(JTree jTree) {
        TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        if (treeCellRenderer != null && !(treeCellRenderer instanceof NiceTreeCellRenderer)) {
            jTree.setCellRenderer(new NiceTreeCellRenderer(treeCellRenderer));
            return true;
        }
        return false;
    }

    private static void installRolloverRepaintHandler(final JComponent jComponent) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jComponent.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                jComponent.repaint();
            }
        };
        jComponent.addMouseListener(mouseAdapter);
        jComponent.addMouseMotionListener(mouseAdapter);
    }

    private static void installDefaultTableCellRenderer(JTable jTable, Class<?> clazz) {
        jTable.setDefaultRenderer(clazz, NiceTableCellRenderer.wrap(jTable.getDefaultRenderer(clazz)));
    }

    private static <C extends JComponent> C findChildOfClass(JComponent jComponent, Class<C> clazz) {
        if (clazz.isAssignableFrom(jComponent.getClass())) {
            return (C)((JComponent)clazz.cast(jComponent));
        }
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            C c;
            Component component = jComponent.getComponent(n2);
            if (component instanceof JComponent && (c = NiceStyleFactory.findChildOfClass((JComponent)component, clazz)) != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @FunctionalInterface
    private static interface InitFunction {
        public void init(JComponent var1, SynthUI var2);
    }
}

