/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTableHeaderUI;
import javax.swing.table.TableCellRenderer;

public class NiceTableCellHeaderRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private boolean initialized;
    private int horizontalAlignment;
    private Dimension prefSize;
    private Color fg;

    public NiceTableCellHeaderRenderer(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = (JComponent)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.initializeIfNeeded(jTable, jComponent);
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setHorizontalAlignment(this.horizontalAlignment);
        }
        if (this.prefSize != null) {
            jComponent.setPreferredSize(this.prefSize);
        }
        if (this.fg != null) {
            jComponent.setForeground(this.fg);
        }
        return jComponent;
    }

    private void initializeIfNeeded(JTable jTable, JComponent jComponent) {
        if (!this.initialized) {
            this.initialized = true;
            TableHeaderUI tableHeaderUI = jTable.getTableHeader().getUI();
            if (tableHeaderUI instanceof SynthTableHeaderUI) {
                SynthContext synthContext = ((SynthTableHeaderUI)tableHeaderUI).getContext(jTable.getTableHeader());
                SynthStyle synthStyle = synthContext.getStyle();
                this.horizontalAlignment = synthStyle.getInt(synthContext, "TableHeader.cellHorizontalAlignment", 2);
                this.fg = ColorUtils.ensureAWTColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                int n = synthStyle.getInt(synthContext, "TableHeader.preferredHeight", -1);
                if (n > 0) {
                    this.prefSize = GUI.getScaledDimension((int)10, (int)n);
                }
            }
        }
    }
}

