/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import com.agfa.pacs.listtext.swingx.plaf.synth.NiceLineBorder;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthTableUI;
import javax.swing.table.TableCellRenderer;
import sun.swing.plaf.synth.DefaultSynthStyle;

public class NiceTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private boolean initialized;
    private Border border;
    private Border insetsBorder;
    private Border gridBorder;
    private Border lineBorder;
    private Color gridColor;
    private Color unselectedBackground;
    private Color unselectedForeground;
    private Color rolloverBackground;
    private Color rolloverForeground;

    private NiceTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
    }

    public static NiceTableCellRenderer wrap(TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer == null) {
            return null;
        }
        if (tableCellRenderer instanceof NiceTableCellRenderer) {
            return (NiceTableCellRenderer)tableCellRenderer;
        }
        return new NiceTableCellRenderer(tableCellRenderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3;
        JComponent jComponent = this.initRenderer(jTable, object, bl, bl2, n, n2);
        Point point = jTable.getMousePosition();
        boolean bl4 = bl3 = point != null && n >= 0 && n == jTable.rowAtPoint(point);
        if (bl3) {
            if (this.rolloverBackground != null) {
                jComponent.setBackground(this.rolloverBackground);
            }
            if (this.rolloverForeground != null) {
                jComponent.setForeground(this.rolloverForeground);
            }
        } else if (!bl) {
            jComponent.setBackground(this.unselectedBackground);
            jComponent.setForeground(this.unselectedForeground);
        }
        if (jComponent instanceof JCheckBox) {
            jComponent.setOpaque(bl || bl3 && this.rolloverBackground != null);
        }
        if (this.border != null) {
            jComponent.setBorder(this.border);
        }
        return jComponent;
    }

    private static Border createCompoundBorder(Border border, Border border2) {
        if (border != null && border2 != null) {
            return BorderFactory.createCompoundBorder(border, border2);
        }
        if (border != null) {
            return border;
        }
        if (border2 != null) {
            return border2;
        }
        return null;
    }

    private JComponent initRenderer(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.initializeIfNeeded(jTable, object, n, n2);
        if (jComponent == null || bl || bl2) {
            jComponent = (JComponent)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return jComponent;
    }

    private JComponent initializeIfNeeded(JTable jTable, Object object, int n, int n2) {
        if (!this.initialized) {
            this.initialized = true;
            JComponent jComponent = (JComponent)this.delegate.getTableCellRendererComponent(jTable, object, false, false, n, n2);
            this.unselectedBackground = jComponent.getBackground();
            this.unselectedForeground = jComponent.getForeground();
            TableUI tableUI = jTable.getUI();
            if (tableUI instanceof SynthTableUI) {
                Object object2;
                Object object3;
                SynthContext synthContext = ((SynthTableUI)tableUI).getContext(jTable);
                int n3 = synthContext.getStyle().getInt(synthContext, "Table.cellGridMargin", -1);
                if (!(n3 < 0 || this.gridBorder != null && this.gridColor != null && this.gridColor.equals(jTable.getGridColor()))) {
                    this.gridColor = jTable.getGridColor();
                    this.gridBorder = new NiceLineBorder(new NiceLineBorder.NiceBorderColor(this.gridColor), new NiceLineBorder.NiceBorderThickness(n3, 0, 0, n3));
                }
                if ((object3 = synthContext.getStyle().get(synthContext, "Table.cellInsets")) instanceof Insets && this.insetsBorder == null) {
                    object2 = (Insets)object3;
                    this.insetsBorder = BorderFactory.createEmptyBorder(((Insets)object2).top, ((Insets)object2).left, ((Insets)object2).bottom, ((Insets)object2).right);
                }
                if ((object2 = synthContext.getStyle().get(synthContext, "Table.cellBorderColor")) instanceof Color && this.lineBorder == null) {
                    this.lineBorder = BorderFactory.createLineBorder((Color)object2, 1);
                }
                this.border = NiceTableCellRenderer.createCompoundBorder(NiceTableCellRenderer.createCompoundBorder(this.gridBorder, this.lineBorder), this.insetsBorder);
                this.rolloverBackground = ColorUtils.ensureAWTColor(((DefaultSynthStyle)synthContext.getStyle()).getColor(jTable, Region.TABLE, 2, ColorType.TEXT_BACKGROUND));
                this.rolloverForeground = ColorUtils.ensureAWTColor(((DefaultSynthStyle)synthContext.getStyle()).getColor(jTable, Region.TABLE, 2, ColorType.TEXT_FOREGROUND));
            }
            return jComponent;
        }
        return null;
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }
}

