/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import sun.swing.plaf.synth.DefaultSynthStyle;

public class NiceTreeCellRenderer
implements TreeCellRenderer {
    private TreeCellRenderer delegate;
    private MouseHandler mouseHandler;
    private boolean initialized;
    private Color background;
    private Color selectionBackground;
    private Color selectionForeground;
    private Color rolloverBackground;
    private Color rolloverForeground;

    public NiceTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.delegate = treeCellRenderer;
    }

    public TreeCellRenderer getDelegate() {
        return this.delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            this.initializeIfNeeded(jTree, this.delegate, jLabel);
            jLabel.setOpaque(false);
            jLabel.setBackground(this.background);
            if (bl) {
                if (this.selectionBackground != null) {
                    jLabel.setOpaque(true);
                    jLabel.setBackground(this.selectionBackground);
                }
                if (this.selectionForeground != null) {
                    jLabel.setForeground(this.selectionForeground);
                }
            }
            if ((this.rolloverBackground != null || this.rolloverForeground != null) && this.mouseHandler != null && this.mouseHandler.isMouseOverRow(n)) {
                if (this.rolloverBackground != null) {
                    jLabel.setOpaque(true);
                    jLabel.setBackground(this.rolloverBackground);
                }
                if (this.rolloverForeground != null) {
                    jLabel.setForeground(this.rolloverForeground);
                }
            }
        }
        return component;
    }

    private void initializeIfNeeded(JTree jTree, TreeCellRenderer treeCellRenderer, JLabel jLabel) {
        if (!this.initialized) {
            try {
                SynthStyle synthStyle;
                this.mouseHandler = MouseHandler.install(jTree);
                this.background = treeCellRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)treeCellRenderer).getBackgroundNonSelectionColor() : jLabel.getBackground();
                if (this.background == null) {
                    this.background = new Color(0, 0, 0, 0);
                }
                if ((synthStyle = SynthLookAndFeel.getStyle(jTree, Region.TREE_CELL)) instanceof DefaultSynthStyle) {
                    DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)synthStyle;
                    this.selectionBackground = ColorUtils.ensureAWTColor(defaultSynthStyle.getColor(jTree, Region.TREE_CELL, 512, ColorType.TEXT_BACKGROUND));
                    this.selectionForeground = ColorUtils.ensureAWTColor(defaultSynthStyle.getColor(jTree, Region.TREE_CELL, 512, ColorType.TEXT_FOREGROUND));
                    this.rolloverBackground = ColorUtils.ensureAWTColor(defaultSynthStyle.getColor(jTree, Region.TREE_CELL, 2, ColorType.TEXT_BACKGROUND));
                    this.rolloverForeground = ColorUtils.ensureAWTColor(defaultSynthStyle.getColor(jTree, Region.TREE_CELL, 2, ColorType.TEXT_FOREGROUND));
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    private static class MouseHandler
    extends MouseAdapter {
        private JTree tree;
        private int hoveredRow;

        private MouseHandler(JTree jTree) {
            this.tree = jTree;
        }

        public static MouseHandler install(JTree jTree) {
            MouseHandler mouseHandler = new MouseHandler(jTree);
            jTree.addMouseListener(mouseHandler);
            jTree.addMouseMotionListener(mouseHandler);
            return mouseHandler;
        }

        public boolean isMouseOverRow(int n) {
            return n >= 0 && this.hoveredRow == n;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.tree.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            this.hoveredRow = this.tree.getRowForLocation(point.x, point.y);
            this.tree.repaint();
        }
    }
}

