/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import com.agfa.pacs.listtext.swingx.plaf.NiceTheme;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.tree.TreePath;

public class NiceTreeUI
extends SynthTreeUI {
    private Icon expandedIconRollover;
    private Icon collapsedIconRollover;
    private Icon worklistCollapsedIcon;
    private Icon worklistExpandedIcon;
    private TreePath currentPath;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NiceTreeUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SynthContext synthContext = this.getContext(this.tree);
        if (synthContext != null) {
            this.expandedIconRollover = NiceTheme.get().getWorklistSkin().getExpandedRolloverIcon();
            this.collapsedIconRollover = NiceTheme.get().getWorklistSkin().getCollapsedRolloverIcon();
            this.worklistCollapsedIcon = NiceTheme.get().getWorklistSkin().getCollapsedIcon();
            this.worklistExpandedIcon = NiceTheme.get().getWorklistSkin().getExpandedIcon();
        }
    }

    @Override
    public Icon getExpandedIcon() {
        if (this.expandedIconRollover != null && this.currentPath != null) {
            TreePath treePath = this.currentPath;
            this.currentPath = null;
            if (this.isMouseOverExpandControl(treePath)) {
                return this.expandedIconRollover;
            }
        }
        if (this.worklistExpandedIcon != null && Objects.equals(this.tree.getName(), "WorklistTree")) {
            return this.worklistExpandedIcon;
        }
        return super.getExpandedIcon();
    }

    @Override
    public Icon getCollapsedIcon() {
        if (this.collapsedIconRollover != null && this.currentPath != null) {
            TreePath treePath = this.currentPath;
            this.currentPath = null;
            if (this.isMouseOverExpandControl(treePath)) {
                return this.collapsedIconRollover;
            }
        }
        if (this.worklistCollapsedIcon != null && Objects.equals(this.tree.getName(), "WorklistTree")) {
            return this.worklistCollapsedIcon;
        }
        return super.getCollapsedIcon();
    }

    @Override
    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        this.currentPath = treePath;
        super.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        this.currentPath = null;
    }

    private boolean isMouseOverExpandControl(TreePath treePath) {
        Point point;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
            SwingUtilities.convertPointFromScreen(point, this.tree);
            if (point != null && this.isLocationInExpandControl(treePath, point.x, point.y)) {
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                if (point.y >= rectangle.y && point.y < rectangle.y + rectangle.height) {
                    return true;
                }
            }
        }
        return false;
    }
}

