/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util.graphics;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class ColorUtils {
    public static final String BLACK = "color.black";
    public static final String WHITE = "color.white";
    public static final String WARNING_COLOR = "color.warning";
    public static final String OK_WITH_PROBLEMS = "color.okWithProblems";
    public static final String OK_COLOR = "color.ok";
    public static final String PRIMARY_COLOR1 = "color.primary.1";
    public static final String PRIMARY_COLOR2 = "color.primary.2";
    public static final String PRIMARY_COLOR3 = "color.primary.3";
    public static final String PRIMARY_COLOR4 = "color.primary.4";
    public static final String PRIMARY_COLOR5 = "color.primary.5";
    public static final String PRIMARY_COLOR6 = "color.primary.6";
    public static final String PRIMARY_COLOR7 = "color.primary.7";
    public static final String PRIMARY_COLOR8 = "color.primary.8";
    public static final String SECONDARY_COLOR_PREFIX = "color.secondary.";
    public static final String SECONDARY_COLOR1 = "color.secondary.1";
    public static final String SECONDARY_COLOR2 = "color.secondary.2";
    public static final String SECONDARY_COLOR3 = "color.secondary.3";
    public static final String SECONDARY_COLOR4 = "color.secondary.4";
    public static final String SECONDARY_COLOR5 = "color.secondary.5";
    public static final String SECONDARY_COLOR6 = "color.secondary.6";
    public static final String SECONDARY_COLOR7 = "color.secondary.7";
    public static final String SECONDARY_COLOR8 = "color.secondary.8";
    public static final String SELECTION_COLOR1 = "color.selection.1";
    public static final String SELECTION_COLOR2 = "color.selection.2";
    public static final String SELECTION_COLOR3 = "color.selection.3";
    public static final String SELECTION_COLOR4 = "color.selection.4";
    public static final String SELECTION_COLOR5 = "color.selection.5";
    public static final String CONFIRM_COLOR1 = "color.confirm.1";
    public static final String CONFIRM_COLOR2 = "color.confirm.2";
    public static final String CONFIRM_COLOR3 = "color.confirm.3";
    public static final String CONFIRM_COLOR4 = "color.confirm.4";
    public static final String CONFIRM_COLOR5 = "color.confirm.5";
    public static final String CONFIRM_COLOR6 = "color.confirm.6";
    public static final String WARNING_COLOR0 = "color.warning.0";
    public static final String WARNING_COLOR1 = "color.warning.1";
    public static final String WARNING_COLOR2 = "color.warning.2";
    public static final String WARNING_COLOR3 = "color.warning.3";
    public static final String WARNING_COLOR4 = "color.warning.4";
    public static final String ERROR_COLOR1 = "color.error.1";
    public static final String ERROR_COLOR2 = "color.error.2";
    public static final String ERROR_COLOR3 = "color.error.3";
    public static final String ERROR_COLOR4 = "color.error.4";
    public static final String ERROR_COLOR5 = "color.error.5";
    public static final String ERROR_COLOR6 = "color.error.6";
    public static final String HIGHLIGHT1 = "color.highlight.1";
    public static final String MOUSEOVER1 = "color.mouseover.1";
    public static final String PERMISSION_ALLOWED = "color.confirm.5";
    public static final String PERMISSION_DENIED = "color.error.3";
    public static final String PERMISSION_UNSPECIFIED = "color.secondary.5";
    public static final String PERMISSION_ALLOWED_MONO = "color.secondary.8";
    public static final String PERMISSION_DENIED_MONO = "color.secondary.3";
    public static final String PERMISSION_UNSPECIFIED_MONO = "color.secondary.5";
    public static final String PRIORS_SELECTED_BACKGROUND = "color.selection.1";
    public static final String PRIORS_ACTUAL_BACKGROUND = "color.secondary.4";
    public static final String PRIORS_PRIOR_BACKGROUND = "color.primary.2";
    public static final String PRIORS_OLD_BACKGROUND = "color.secondary.1";
    public static final String PRIORS_SELECTED_FOREGROUND = "color.secondary.8";
    public static final String PRIORS_ACTUAL_FOREGROUND = "color.secondary.8";
    public static final String PRIORS_PRIOR_FOREGROUND = "color.secondary.8";
    public static final String PRIORS_OLD_FOREGROUND = "color.secondary.5";

    public static Color getColor(String string) {
        return UIManager.getColor(string);
    }

    public static Color getWhite() {
        return ColorUtils.getColor(WHITE);
    }

    public static Color getBlack() {
        return ColorUtils.getColor(BLACK);
    }

    public static Color getOKColor() {
        return ColorUtils.getColor(OK_COLOR);
    }

    public static Color getWarningColor() {
        return ColorUtils.getColor(WARNING_COLOR);
    }

    public static Color getPrimary1() {
        return ColorUtils.getColor(PRIMARY_COLOR1);
    }

    public static Color getPrimary2() {
        return ColorUtils.getColor("color.primary.2");
    }

    public static Color getPrimary3() {
        return ColorUtils.getColor(PRIMARY_COLOR3);
    }

    public static Color getPrimary4() {
        return ColorUtils.getColor(PRIMARY_COLOR4);
    }

    public static Color getPrimary5() {
        return ColorUtils.getColor(PRIMARY_COLOR5);
    }

    public static Color getPrimary6() {
        return ColorUtils.getColor(PRIMARY_COLOR6);
    }

    public static Color getPrimary7() {
        return ColorUtils.getColor(PRIMARY_COLOR7);
    }

    public static Color getPrimary8() {
        return ColorUtils.getColor(PRIMARY_COLOR8);
    }

    public static Color getSecondary1() {
        return ColorUtils.getColor("color.secondary.1");
    }

    public static Color getSecondary2() {
        return ColorUtils.getColor(SECONDARY_COLOR2);
    }

    public static Color getSecondary3() {
        return ColorUtils.getColor("color.secondary.3");
    }

    public static Color getSecondary4() {
        return ColorUtils.getColor("color.secondary.4");
    }

    public static Color getSecondary5() {
        return ColorUtils.getColor("color.secondary.5");
    }

    public static Color getSecondary6() {
        return ColorUtils.getColor(SECONDARY_COLOR6);
    }

    public static Color getSecondary7() {
        return ColorUtils.getColor(SECONDARY_COLOR7);
    }

    public static Color getSecondary8() {
        return ColorUtils.getColor("color.secondary.8");
    }

    public static Color getSelection1() {
        return ColorUtils.getColor("color.selection.1");
    }

    public static Color getSelection2() {
        return ColorUtils.getColor(SELECTION_COLOR2);
    }

    public static Color getSelection3() {
        return ColorUtils.getColor(SELECTION_COLOR3);
    }

    public static Color getSelection4() {
        return ColorUtils.getColor(SELECTION_COLOR4);
    }

    public static Color getSelection5() {
        return ColorUtils.getColor(SELECTION_COLOR5);
    }

    public static Color getConfirm1() {
        return ColorUtils.getColor(CONFIRM_COLOR1);
    }

    public static Color getConfirm2() {
        return ColorUtils.getColor(CONFIRM_COLOR2);
    }

    public static Color getConfirm3() {
        return ColorUtils.getColor(CONFIRM_COLOR3);
    }

    public static Color getConfirm4() {
        return ColorUtils.getColor(CONFIRM_COLOR4);
    }

    public static Color getWarning0() {
        return ColorUtils.getColor(WARNING_COLOR0);
    }

    public static Color getWarning1() {
        return ColorUtils.getColor(WARNING_COLOR1);
    }

    public static Color getWarning2() {
        return ColorUtils.getColor(WARNING_COLOR2);
    }

    public static Color getWarning3() {
        return ColorUtils.getColor(WARNING_COLOR3);
    }

    public static Color getWarning4() {
        return ColorUtils.getColor(WARNING_COLOR4);
    }

    public static Color getError1() {
        return ColorUtils.getColor(ERROR_COLOR1);
    }

    public static Color getError2() {
        return ColorUtils.getColor(ERROR_COLOR2);
    }

    public static Color getError3() {
        return ColorUtils.getColor("color.error.3");
    }

    public static Color getError4() {
        return ColorUtils.getColor(ERROR_COLOR4);
    }

    public static Color getError5() {
        return ColorUtils.getColor(ERROR_COLOR5);
    }

    public static Color getError6() {
        return ColorUtils.getColor(ERROR_COLOR6);
    }

    public static Color getHighlight1() {
        return ColorUtils.getColor(HIGHLIGHT1);
    }

    public static Color getMouseOver1() {
        return ColorUtils.getColor(MOUSEOVER1);
    }

    public static boolean isBright(Color color) {
        return ColorUtils.isBright(color, 0.5);
    }

    public static boolean isBright(Color color, double d) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if ((double)fArray[2] < d) {
            return false;
        }
        if ((double)fArray[1] < d) {
            return true;
        }
        return color.getRed() >= 150 || color.getGreen() >= 150 || color.getBlue() >= 150;
    }

    public static boolean isBrighter(Color color, Color color2) {
        float[] fArray;
        float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return fArray2[2] > (fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[2];
    }

    public static Color darker(Color color, float f) {
        if (color == null) {
            return null;
        }
        return new Color(Math.max((int)Math.min((float)color.getRed() * f, 255.0f), 0), Math.max((int)Math.min((float)color.getGreen() * f, 255.0f), 0), Math.max((int)Math.min((float)color.getBlue() * f, 255.0f), 0));
    }

    public static Color brighter(Color color, float f) {
        int n;
        if (color == null) {
            return null;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = n = f == 1.0f ? 255 : (int)(1.0 / (1.0 - (double)f));
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            int n6 = (int)(255.0 * (1.0 - (double)f));
            return new Color(n6, n6, n6);
        }
        if (n2 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 > 0 && n3 < n) {
            n3 = n;
        }
        if (n4 > 0 && n4 < n) {
            n4 = n;
        }
        return new Color(Math.max(Math.min((int)((float)n2 / f), 255), 0), Math.max(Math.min((int)((float)n3 / f), 255), 0), Math.max(Math.min((int)((float)n4 / f), 255), 0));
    }

    public static Color blend(Color color, Color color2, float f) {
        float f2 = f;
        float f3 = 1.0f - f2;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        color.getColorComponents(fArray);
        color2.getColorComponents(fArray2);
        return new Color(fArray[0] * f3 + fArray2[0] * f2, fArray[1] * f3 + fArray2[1] * f2, fArray[2] * f3 + fArray2[2] * f2);
    }

    public static Color applyAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color ensureAWTColor(Color color) {
        if (color instanceof ColorUIResource) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return color;
    }
}

