/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util.graphics;

import com.agfa.pacs.logging.ALogger;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;

public class IconLoader {
    private static final ALogger log = ALogger.getLogger(IconLoader.class);

    public static Image getImage(String string, ClassLoader classLoader) throws InterruptedException, IOException {
        try {
            URL uRL = classLoader.getResource(string);
            Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
            MediaTracker mediaTracker = new MediaTracker(new Panel());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            return image;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public static Image getImage(String string) throws InterruptedException, IOException {
        return IconLoader.getImage(string, IconLoader.class.getClassLoader());
    }

    public static Image getScaledImage(String string, ClassLoader classLoader, Dimension dimension) throws InterruptedException, IOException {
        return IconLoader.getImage(string, classLoader).getScaledInstance(dimension.width, dimension.height, 4);
    }

    public static Image getScaledImage(String string, ClassLoader classLoader, int n, int n2) throws InterruptedException, IOException {
        return IconLoader.getImage(string, classLoader).getScaledInstance(n, n2, 4);
    }

    public static ImageIcon getIcon(String string, ClassLoader classLoader, double d) {
        try {
            if (Math.abs(d - 1.0) < 0.01) {
                return new ImageIcon(IconLoader.getImage(string, classLoader));
            }
            Image image = IconLoader.getImage(string, classLoader);
            return new ImageIcon(image.getScaledInstance((int)Math.round((double)image.getWidth(null) * d), (int)Math.round((double)image.getHeight(null) * d), 4));
        }
        catch (Exception exception) {
            log.warn("Could not load icon:" + string);
            return null;
        }
    }

    public static ImageIcon getScaledIcon(String string, ClassLoader classLoader, Dimension dimension) throws InterruptedException, IOException {
        return new ImageIcon(IconLoader.getScaledImage(string, classLoader, dimension));
    }

    public static ImageIcon getScaledIcon(String string, ClassLoader classLoader, int n, int n2) {
        try {
            return new ImageIcon(IconLoader.getScaledImage(string, classLoader, n, n2));
        }
        catch (Exception exception) {
            log.warn("Could not load icon:" + string);
            return null;
        }
    }

    public static Image getScaledImage(String string, Dimension dimension) throws InterruptedException, IOException {
        return IconLoader.getImage(string).getScaledInstance(dimension.width, dimension.height, 4);
    }

    public static Image getScaledImage(String string, int n, int n2) throws InterruptedException, IOException {
        return IconLoader.getImage(string).getScaledInstance(n, n2, 4);
    }

    public static ImageIcon getIcon(String string) throws InterruptedException, IOException {
        return new ImageIcon(IconLoader.getImage(string));
    }

    public static ImageIcon getScaledIcon(String string, Dimension dimension) throws InterruptedException, IOException {
        return new ImageIcon(IconLoader.getScaledImage(string, dimension));
    }

    public static ImageIcon getScaledIcon(String string, int n, int n2) throws InterruptedException, IOException {
        return new ImageIcon(IconLoader.getScaledImage(string, n, n2));
    }

    public static ImageIcon loadScaledIcon(String string, int n, int n2) {
        try {
            ImageIcon imageIcon = IconLoader.getScaledIcon(string, n, n2);
            return imageIcon;
        }
        catch (Exception exception) {
            log.warn("Loading icon {} failed.'", (Object)string);
            return null;
        }
    }

    public static ImageIcon loadScaledIcon(String string, ClassLoader classLoader, int n, int n2) {
        try {
            ImageIcon imageIcon = IconLoader.getScaledIcon(string, classLoader, n, n2);
            return imageIcon;
        }
        catch (Exception exception) {
            log.warn("Loading icon {} failed.'", (Object)string);
            return null;
        }
    }

    public static ImageIcon loadIcon(String string) {
        try {
            ImageIcon imageIcon = IconLoader.getIcon(string);
            return imageIcon;
        }
        catch (Exception exception) {
            log.error("Loading icon {} failed.'", (Object)string);
            return null;
        }
    }
}

