/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;

public class Log
implements ILog,
SynchronousLogListener,
LogFilter {
    final Bundle bundle;
    private final Logger logger;
    private final Set logListeners = new HashSet(5);

    public Log(Bundle bundle, Logger logger) {
        this.bundle = bundle;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(ILogListener iLogListener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.add(iLogListener);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void log(IStatus iStatus) {
        this.logger.log((Object)PlatformLogWriter.getLog((IStatus)iStatus), PlatformLogWriter.getLevel((IStatus)iStatus), iStatus.getMessage(), iStatus.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(ILogListener iLogListener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.remove(iLogListener);
        }
    }

    public void logged(LogEntry logEntry) {
        this.logToListeners(PlatformLogWriter.convertToStatus((LogEntry)logEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToListeners(final IStatus iStatus) {
        ILogListener[] iLogListenerArray;
        Set set = this.logListeners;
        synchronized (set) {
            iLogListenerArray = this.logListeners.toArray(new ILogListener[this.logListeners.size()]);
        }
        int n = 0;
        while (n < iLogListenerArray.length) {
            final ILogListener iLogListener = iLogListenerArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iLogListener.logging(iStatus, Log.this.bundle.getSymbolicName());
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    public boolean isLoggable(Bundle bundle, String string, int n) {
        return "org.eclipse.equinox.logger".equals(string) && this.bundle.getBundleId() == bundle.getBundleId();
    }
}

