/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.internal.preferences.legacy.PreferenceForwarder;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class Plugin
implements BundleActivator {
    public static final String PLUGIN_PREFERENCE_SCOPE = "instance";
    private Bundle bundle;
    private boolean debug = false;
    private ServiceTracker debugTracker = null;
    private IPluginDescriptor descriptor;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    private Preferences preferences = null;
    static /* synthetic */ Class class$0;

    public Plugin() {
    }

    public Plugin(IPluginDescriptor iPluginDescriptor) {
        Assert.isNotNull((Object)iPluginDescriptor);
        Assert.isTrue((!CompatibilityHelper.hasPluginObject(iPluginDescriptor) ? 1 : 0) != 0, (String)NLS.bind((String)Messages.plugin_deactivatedLoad, (Object)this.getClass().getName(), (Object)(String.valueOf(iPluginDescriptor.getUniqueIdentifier()) + " is not activated")));
        this.descriptor = iPluginDescriptor;
        this.bundle = InternalPlatform.getDefault().getBundle(iPluginDescriptor.getUniqueIdentifier());
        try {
            InternalPlatform.start(this.bundle);
        }
        catch (BundleException bundleException) {
            String string = NLS.bind((String)Messages.plugin_startupProblems, (Object)iPluginDescriptor.getUniqueIdentifier());
            Status status = new Status(4, "org.eclipse.core.runtime", 4, string, (Throwable)bundleException);
            InternalPlatform.getDefault().log((IStatus)status);
        }
    }

    public final URL find(IPath iPath) {
        return FileLocator.find((Bundle)this.bundle, (IPath)iPath, null);
    }

    public final URL find(IPath iPath, Map map) {
        return FileLocator.find((Bundle)this.bundle, (IPath)iPath, (Map)map);
    }

    public final IPluginDescriptor getDescriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        return this.initializeDescriptor(this.bundle.getSymbolicName());
    }

    public final ILog getLog() {
        return InternalPlatform.getDefault().getLog(this.bundle);
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return InternalPlatform.getDefault().getStateLocation(this.bundle, true);
    }

    public final Preferences getPluginPreferences() {
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Plugin preferences already loaded for: " + this.bundle.getSymbolicName());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Loading preferences for plugin: " + this.bundle.getSymbolicName());
        }
        final Bundle bundle = this.bundle;
        final Preferences[] preferencesArray = new Preferences[1];
        Runnable runnable = new Runnable(){

            public void run() {
                preferencesArray[0] = new PreferenceForwarder(this, bundle.getSymbolicName());
            }
        };
        runnable.run();
        this.preferences = preferencesArray[0];
        return this.preferences;
    }

    public final void savePluginPreferences() {
        Location location = InternalPlatform.getDefault().getInstanceLocation();
        if (location == null || !location.isSet()) {
            return;
        }
        this.getPluginPreferences();
        final Preferences preferences = this.preferences;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ((PreferenceForwarder)preferences).flush();
                }
                catch (BackingStoreException backingStoreException) {
                    Status status = new Status(4, "org.eclipse.core.runtime", 4, Messages.preferences_saveProblems, (Throwable)backingStoreException);
                    InternalPlatform.getDefault().log((IStatus)status);
                }
            }
        };
        runnable.run();
    }

    protected void initializeDefaultPluginPreferences() {
    }

    public final void internalInitializeDefaultPluginPreferences() {
        this.initializeDefaultPluginPreferences();
    }

    public boolean isDebugging() {
        if (this.bundle == null) {
            return this.debug;
        }
        String string = String.valueOf(this.bundle.getSymbolicName()) + "/debug";
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return this.debug;
        }
        return debugOptions.isDebugEnabled() ? InternalPlatform.getDefault().getBooleanOption(string, false) : false;
    }

    public final InputStream openStream(IPath iPath) throws IOException {
        return FileLocator.openStream((Bundle)this.bundle, (IPath)iPath, (boolean)false);
    }

    public final InputStream openStream(IPath iPath, boolean bl) throws IOException {
        return FileLocator.openStream((Bundle)this.bundle, (IPath)iPath, (boolean)bl);
    }

    public void setDebugging(boolean bl) {
        if (this.bundle == null) {
            this.debug = bl;
            return;
        }
        String string = String.valueOf(this.bundle.getSymbolicName()) + "/debug";
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            this.debug = bl;
        } else {
            if (!debugOptions.isDebugEnabled()) {
                debugOptions.setDebugEnabled(true);
            }
            debugOptions.setOption(string, bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    private DebugOptions getDebugOptions() {
        if (this.bundle == null) {
            return null;
        }
        if (this.debugTracker == null) {
            BundleContext bundleContext = this.bundle.getBundleContext();
            if (bundleContext == null) {
                return null;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public void shutdown() throws CoreException {
        if (CompatibilityHelper.initializeCompatibility() == null) {
            return;
        }
        Exception exception = null;
        try {
            Method method = this.descriptor.getClass().getMethod("doPluginDeactivation", new Class[0]);
            method.invoke((Object)this.descriptor, null);
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception == null) {
            return;
        }
        String string = NLS.bind((String)Messages.plugin_shutdownProblems, (Object)this.descriptor.getUniqueIdentifier());
        Status status = new Status(4, "org.eclipse.core.runtime", 4, string, (Throwable)exception);
        InternalPlatform.getDefault().log((IStatus)status);
    }

    public void startup() throws CoreException {
    }

    public String toString() {
        String string = this.bundle.getSymbolicName();
        return string == null ? new Long(this.bundle.getBundleId()).toString() : string;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundle = bundleContext.getBundle();
        this.initializeDescriptor(this.bundle.getSymbolicName());
    }

    private IPluginDescriptor initializeDescriptor(String string) {
        if (CompatibilityHelper.initializeCompatibility() == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        IPluginDescriptor iPluginDescriptor = CompatibilityHelper.getPluginDescriptor(string);
        if (!string.equals("org.eclipse.core.runtime")) {
            this.descriptor = iPluginDescriptor;
        }
        CompatibilityHelper.setPlugin(iPluginDescriptor, this);
        CompatibilityHelper.setActive(iPluginDescriptor);
        return iPluginDescriptor;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
    }

    public final Bundle getBundle() {
        return this.bundle;
    }
}

