/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.background;

import com.agfa.pacs.background.DoneState;
import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.background.IBackgroundTaskExecutor;
import com.agfa.pacs.background.IProgressListener;
import com.agfa.pacs.background.IScheduledBackgroundTask;
import com.agfa.pacs.background.ProgressProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.ExceptionDialogUtils;
import java.util.Objects;
import java.util.concurrent.Executor;

public class ExecutorBackgroundTaskEngine
implements IBackgroundTaskExecutor {
    private static final ALogger log = ALogger.getLogger(ExecutorBackgroundTaskEngine.class);
    private final Executor executor;

    public ExecutorBackgroundTaskEngine(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public IScheduledBackgroundTask placeBackgroundTask(IBackgroundTask iBackgroundTask) {
        return this.placeBackgroundTask(iBackgroundTask, null);
    }

    @Override
    public IScheduledBackgroundTask placeBackgroundTask(IBackgroundTask iBackgroundTask, IProgressListener<DoneState, String, String> iProgressListener) {
        Objects.requireNonNull(iBackgroundTask);
        log.info("Scheduling background task: {}", (Object)iBackgroundTask);
        final ScheduledBackgroundTask scheduledBackgroundTask = new ScheduledBackgroundTask(iBackgroundTask);
        if (iProgressListener != null) {
            scheduledBackgroundTask.attachProgressListener(iProgressListener);
        }
        this.executor.execute(() -> {
            boolean bl;
            if (!scheduledBackgroundTask.canStart()) {
                return;
            }
            log.info("Starting background task: {}", (Object)iBackgroundTask);
            try {
                iBackgroundTask.take(new IBackgroundProgress(){

                    @Override
                    public void progress(double d, String string) {
                        scheduledBackgroundTask.notifyProgress(d, string);
                    }

                    @Override
                    public void progress(double d) {
                        this.progress(d, null);
                    }
                });
                bl = iBackgroundTask.execute();
            }
            catch (Throwable throwable) {
                bl = false;
                log.error("Unhandled exception in background task:\n", throwable);
                ExceptionDialogUtils.displayExceptionToUser((Throwable)throwable);
            }
            String string = null;
            try {
                string = iBackgroundTask.getInfo();
            }
            catch (Throwable throwable) {
                scheduledBackgroundTask.notifyDone(bl ? DoneState.SUCCESS : DoneState.FAILED, string);
                throw throwable;
            }
            scheduledBackgroundTask.notifyDone(bl ? DoneState.SUCCESS : DoneState.FAILED, string);
        });
        return scheduledBackgroundTask;
    }

    private static class ScheduledBackgroundTask
    extends ProgressProvider<DoneState, String, String>
    implements IScheduledBackgroundTask {
        private final IBackgroundTask task;
        private boolean canceled = false;
        private boolean started = false;

        public ScheduledBackgroundTask(IBackgroundTask iBackgroundTask) {
            this.task = Objects.requireNonNull(iBackgroundTask);
        }

        @Override
        public IBackgroundTask getTask() {
            return this.task;
        }

        protected synchronized boolean canStart() {
            if (this.canceled) {
                this.notifyDone(DoneState.CANCELED, null);
                return false;
            }
            if (this.started) {
                throw new IllegalStateException("Double start of task");
            }
            this.started = true;
            return true;
        }

        @Override
        public synchronized boolean cancel() {
            if (this.isDone) {
                return false;
            }
            this.canceled = true;
            log.info("Cancelling background task: {}", (Object)this.task);
            if (this.started) {
                this.task.terminate();
            }
            return true;
        }

        @Override
        public synchronized void notifyDone(DoneState doneState, String string) {
            if (this.canceled && doneState == DoneState.FAILED) {
                doneState = DoneState.CANCELED;
            }
            log.info("Finished background task with state {}: {}", (Object)doneState, (Object)this.task);
            super.notifyDone(doneState, string);
        }
    }
}

