/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.cache;

import com.agfa.pacs.cache.IMemoryAlertListener;
import java.util.ConcurrentModificationException;
import java.util.WeakHashMap;

public class MemoryAlertHandler {
    static WeakHashMap<IMemoryAlertListener, Object> memAlertListeners = new WeakHashMap();
    static WeakHashMap<IMemoryAlertListener, Object> persistentAlertListeners = new WeakHashMap();

    public static void addMemoryAlertListener(IMemoryAlertListener iMemoryAlertListener) {
        memAlertListeners.put(iMemoryAlertListener, "");
    }

    public static void addPersistentMemoryAlertListener(IMemoryAlertListener iMemoryAlertListener) {
        persistentAlertListeners.put(iMemoryAlertListener, "");
    }

    public static long fireMemoryAlert(long l, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            try {
                for (IMemoryAlertListener iMemoryAlertListener : memAlertListeners.keySet()) {
                    l -= iMemoryAlertListener.memoryAlert(l, bl);
                }
                bl2 = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long firePersistentMemoryAlert(long l, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            WeakHashMap<IMemoryAlertListener, Object> weakHashMap = persistentAlertListeners;
            synchronized (weakHashMap) {
                try {
                    for (IMemoryAlertListener iMemoryAlertListener : persistentAlertListeners.keySet()) {
                        l -= iMemoryAlertListener.memoryAlert(l, bl);
                    }
                    bl2 = true;
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            }
        }
        return l;
    }
}

