/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.cache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.cache.IPersistentCacheGroup;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.concurrent.IUsageSynchronizer;
import com.agfa.pacs.tools.concurrent.UsageDisposeSynchronizer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PersistentCacheGroup
implements IPersistentCacheGroup {
    private static final ALogger log = ALogger.getLogger(PersistentCacheGroup.class);
    private final UsageDisposeSynchronizer usageSynchronizer = new UsageDisposeSynchronizer();
    private final IDataCacheProvider delegate = DataCacheProviderFactory.getCache();
    private final String groupId;
    private final Set<CacheID> usedCacheIDs = Collections.newSetFromMap(new ConcurrentHashMap());

    public PersistentCacheGroup(String string) {
        this(string, false);
    }

    private PersistentCacheGroup(String string, boolean bl) {
        this.groupId = string;
        if (!bl) {
            log.info("Creation of cache group: {}", (Object)string);
        } else {
            this.usageSynchronizer.requestDisposePermit();
        }
    }

    public static IPersistentCacheGroup provideDisposedDummyGroup(String string) {
        return new PersistentCacheGroup(string, true);
    }

    @Override
    public CacheID createPermanentGroupCacheID(String string) {
        return this.delegate.createID(this.groupId, string, 1);
    }

    @Override
    public GrouplessID createNewTemporaryCacheID() {
        return this.delegate.createNewTemporaryCacheID();
    }

    @Override
    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentBytes(byArray, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    private static void logDisposedAdd(CacheID cacheID) {
        log.warn("Cannot add data because the cache group is already disposed. This indicates that the usageSynchronizer is not used correctly when accessing the cache group. CacheID: {}", (Object)cacheID);
    }

    @Override
    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentBytes(byArray, cacheID, n);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentDoubles(dArray, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentFloats(fArray, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentInts(nArray, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentInts(nArray, cacheID, n);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentObject(Object object, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentObject(object, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentObject(object, cacheID, n);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentObject(object, clazz, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentShorts(sArray, cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            PersistentCacheGroup.logDisposedAdd(cacheID);
            return;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            this.delegate.addPersistentShorts(sArray, cacheID, n);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public boolean exists(Class<?> clazz, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            log.warn("Cannot check for exists because the cache group is already disposed. This indicates that the usageSynchronizer is not used correctly when accessing the cache group. CacheID: {}", (Object)cacheID);
            return false;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            boolean bl = this.delegate.exists(clazz, cacheID);
            return bl;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            log.warn("Cannot check for isInCache because the cache group is already disposed. This indicates that the usageSynchronizer is not used correctly when accessing the cache group. CacheID: {}", (Object)cacheID);
            return false;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            boolean bl = this.delegate.isInCache(clazz, cacheID);
            return bl;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public boolean isInMemory(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            log.warn("Cannot check for isInMemory because the cache group is already disposed. This indicates that the usageSynchronizer is not used correctly when accessing the cache group. CacheID: {}", (Object)cacheID);
            return false;
        }
        try {
            this.usedCacheIDs.add(cacheID);
            boolean bl = this.delegate.isInMemory(cacheID);
            return bl;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    private void throwExceptionForDisposedGroup(CacheID cacheID) {
        throw new IllegalStateException("Data group " + this.groupId + " was already disposed when trying to access " + cacheID);
    }

    private void throwExceptionIfGroupDisposed(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public byte[] referencePersistentBytes(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            byte[] byArray = this.delegate.referencePersistentBytes(cacheID);
            return byArray;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public double[] referencePersistentDoubles(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            double[] dArray = this.delegate.referencePersistentDoubles(cacheID);
            return dArray;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public float[] referencePersistentFloats(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            float[] fArray = this.delegate.referencePersistentFloats(cacheID);
            return fArray;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public int[] referencePersistentInts(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            int[] nArray = this.delegate.referencePersistentInts(cacheID);
            return nArray;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            Object object = this.delegate.referencePersistentObject(cacheID, clazz);
            return object;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public short[] referencePersistentShorts(CacheID cacheID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            this.throwExceptionForDisposedGroup(cacheID);
        }
        try {
            this.usedCacheIDs.add(cacheID);
            short[] sArray = this.delegate.referencePersistentShorts(cacheID);
            return sArray;
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.delegate.releaseModifiedArrayReference(cacheID, lArray, lArray2);
        this.throwExceptionIfGroupDisposed(cacheID);
    }

    @Override
    public void releaseModifiedReference(CacheID cacheID) {
        this.delegate.releaseModifiedReference(cacheID);
        this.throwExceptionIfGroupDisposed(cacheID);
    }

    @Override
    public void releaseReference(CacheID cacheID) {
        this.delegate.releaseReference(cacheID);
        this.throwExceptionIfGroupDisposed(cacheID);
    }

    @Override
    public void removeTemporary(GrouplessID grouplessID) {
        if (!this.usageSynchronizer.requestUsagePermit()) {
            return;
        }
        try {
            this.usedCacheIDs.remove(grouplessID);
            this.delegate.removeTemporary(grouplessID);
        }
        finally {
            this.usageSynchronizer.releaseUsagePermit();
        }
    }

    @Override
    public int getItemPriority(CacheID cacheID) {
        return this.delegate.getItemPriority(cacheID);
    }

    @Override
    public IUsageSynchronizer getUsageSynchronizer() {
        return this.usageSynchronizer;
    }

    public boolean dispose() {
        if (!this.usageSynchronizer.requestDisposePermit()) {
            return false;
        }
        log.info("Disposal of cache group: {}", (Object)this.groupId);
        for (CacheID cacheID : this.usedCacheIDs) {
            this.delegate.remove(cacheID);
        }
        return true;
    }
}

