/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ConfigUtilities {
    private static final ALogger LOGGER = ALogger.getLogger(ConfigUtilities.class);
    private static Boolean debugModus = null;
    private static Boolean german = null;

    @Deprecated
    public static void clearConfigList(IConfigurationList iConfigurationList) {
        if (iConfigurationList != null && iConfigurationList.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, IConfigurationProvider> object : iConfigurationList.getChildrenItems().entrySet()) {
                arrayList.add(object.getKey());
            }
            for (String string : arrayList) {
                iConfigurationList.remove(string);
            }
        }
    }

    public static void matchListsLong(IConfigurationList iConfigurationList, String string, List<Long> list) {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, IConfigurationProvider> entry : iConfigurationList.getChildrenItems().entrySet()) {
            object = entry.getValue().getLong(string);
            if (!list.contains(object)) {
                linkedList.add(entry.getKey());
                continue;
            }
            list.remove(object);
        }
        for (String string2 : linkedList) {
            iConfigurationList.remove(string2);
        }
        for (Long l : list) {
            object = iConfigurationList.appendItem();
            object.setLong(string, l);
        }
    }

    public static void matchListsString(IConfigurationList iConfigurationList, String string, List<String> list) {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, IConfigurationProvider> entry : iConfigurationList.getChildrenItems().entrySet()) {
            object = entry.getValue().getString(string);
            if (!list.contains(object)) {
                linkedList.add(entry.getKey());
                continue;
            }
            list.remove(object);
        }
        for (String string2 : linkedList) {
            iConfigurationList.remove(string2);
        }
        for (String string3 : list) {
            object = iConfigurationList.appendItem();
            object.setString(string, string3);
        }
    }

    public static void saveToConfigAsXML_UTF16(IConfigurationProvider iConfigurationProvider, String string, String string2) throws Exception {
        iConfigurationProvider.setText(string, string2);
    }

    public static Document loadXMLFromConfig_UTF16(IConfigurationProvider iConfigurationProvider, String string) throws Exception {
        InputSource inputSource = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(iConfigurationProvider.getText(string).getBytes("UTF-16")), "UTF-16"));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static void readConfigList(IConfigurationList iConfigurationList, String string, Consumer<IConfigurationProvider> consumer) {
        ArrayList<String> arrayList = null;
        for (Map.Entry<String, IConfigurationProvider> object : iConfigurationList.getChildrenItems().entrySet()) {
            try {
                consumer.accept(object.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = object.getKey();
                LOGGER.warn("Incomplete {} for order ID '{}', deleting...", new Object[]{string, string2, illegalArgumentException});
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(2);
                }
                arrayList.add(string2);
            }
        }
        if (arrayList != null) {
            for (String string3 : arrayList) {
                iConfigurationList.remove(string3);
            }
        }
    }

    public static boolean removeItemsWithoutEntry(IConfigurationList iConfigurationList, String ... stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        block0: for (Map.Entry<String, IConfigurationProvider> object : iConfigurationList.getChildrenItems().entrySet()) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (!object.getValue().exists(string)) {
                    linkedList.add(object.getKey());
                    continue block0;
                }
                ++n2;
            }
        }
        for (String string : linkedList) {
            iConfigurationList.remove(string);
        }
        return linkedList.isEmpty();
    }

    public static boolean removeItem(IConfigurationList iConfigurationList, String string, String string2) {
        for (Map.Entry<String, IConfigurationProvider> entry : iConfigurationList.getChildrenItems().entrySet()) {
            if (!entry.getValue().getString(string).equals(string2)) continue;
            iConfigurationList.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public static boolean removeItem(IConfigurationList iConfigurationList, String string, long l) {
        for (Map.Entry<String, IConfigurationProvider> entry : iConfigurationList.getChildrenItems().entrySet()) {
            try {
                if (entry.getValue().getLong(string) != l) continue;
                iConfigurationList.remove(entry.getKey());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return false;
    }

    public static boolean isDebug() {
        if (debugModus == null) {
            debugModus = Boolean.FALSE;
            String string = System.getProperty("debug");
            if (string != null) {
                try {
                    debugModus = Boolean.valueOf(string);
                }
                catch (Exception exception) {}
            }
        }
        return debugModus;
    }

    public static boolean isGerman() {
        if (german == null) {
            german = "de".equalsIgnoreCase(Locale.getDefault().getLanguage());
        }
        return german;
    }
}

