/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventFilter;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractEventFilter
implements IEventFilter {
    private static final ALogger logger = ALogger.getLogger(AbstractEventFilter.class);
    private static final IEventEngine eef = EventEngineFactory.getInstance();
    protected Map<Integer, IEventFilter.HandlingBehaviour> knownEvents = new HashMap<Integer, IEventFilter.HandlingBehaviour>();

    protected void registerUnknownEvent(int n) {
        String string = eef.getEventName(n);
        if (string != null) {
            this.knownEvents.put(n, this.passesFilter(string, n));
        } else {
            logger.warn("Unknown event id: " + n);
        }
    }

    protected abstract IEventFilter.HandlingBehaviour passesFilter(String var1, int var2);

    @Override
    public final IEventFilter.HandlingBehaviour passesFilter(IEvent iEvent) {
        IEventFilter.HandlingBehaviour handlingBehaviour = this.knownEvents.get(iEvent.getEventID());
        if (handlingBehaviour == null) {
            this.registerUnknownEvent(iEvent.getEventID());
            handlingBehaviour = this.knownEvents.get(iEvent.getEventID());
        }
        return handlingBehaviour;
    }

    @Override
    public void resetCache() {
        this.knownEvents = new HashMap<Integer, IEventFilter.HandlingBehaviour>();
    }
}

