/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEventContext;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import java.io.Serializable;

public interface IEvent
extends Serializable {
    public static final int EVENTID_UNDO = 0;
    public static final int EVENTID_REDO = 1;
    public static final int EVENTID_DUMMY = 2;
    public static final int EVENTID_RENDERER_CHECK = 100;
    public static final int EVENTID_RENDERER_UPDATE = 101;
    public static final int EVENTID_RENDERER_RECALC = 102;
    public static final int EVENTID_RENDERER_CAPTURE = 106;
    public static final int EVENTID_RENDERER_CAPTURE_NO_FLIP_BUFFER = 107;
    public static final int EVENTID_IBX_TILE_SIZE = 108;
    public static final int STATIC_EVENT_BASE = 500;

    public void setActionInfo(ActionInfo var1);

    public ActionInfo getActionInfo();

    public void setDestination(IEventListenerProvider<? extends IEventListener> var1);

    public void setDestination(IEventListenerProvider<? extends IEventListener> var1, String var2);

    public IEventListenerProvider<? extends IEventListener> getProvider();

    public void setSource(Object var1);

    public Object getSource();

    public void setPayload(Object var1);

    public Object getPayload();

    public void setEventID(int var1);

    public int getEventID();

    public boolean isInternal();

    public void setRemoteDispatch(boolean var1);

    public boolean getRemoteDispatch();

    public boolean isScriptable();

    public boolean isSerializable();

    public long getTimeStamp();

    public void setTimeStamp(long var1);

    public long getUID();

    public void setContext(IEventContext var1);

    public IEventContext getContext();

    public static enum Type {
        Normal{

            @Override
            public void sendEvent(IEvent iEvent) {
                EventEngineFactory.getInstance().sendEvent(iEvent);
            }
        }
        ,
        Flushed{

            @Override
            public void sendEvent(IEvent iEvent) {
                EventEngineFactory.getInstance().sendFlushedEvent(iEvent);
            }
        }
        ,
        Blocking{

            @Override
            public void sendEvent(IEvent iEvent) {
                EventEngineFactory.getInstance().sendBlockingEvent(iEvent);
            }
        }
        ,
        Stream{

            @Override
            public void sendEvent(IEvent iEvent) {
                EventEngineFactory.getInstance().sendStreamEvent(iEvent);
            }
        }
        ,
        Exclusive{

            @Override
            public void sendEvent(IEvent iEvent) {
                EventEngineFactory.getInstance().sendExclusiveEvent(iEvent);
            }
        };


        public abstract void sendEvent(IEvent var1);
    }
}

