/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.extensions;

import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ExtensionFactory<T> {
    private static final ALogger log = ALogger.getLogger(ExtensionFactory.class);
    private final List<T> implementations;

    public ExtensionFactory(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(string);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        ArrayList<Object> arrayList = new ArrayList<Object>(iConfigurationElementArray.length);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                arrayList.add(object);
                log.info("Extension point '{}' implemented by {}", (Object)string, object.getClass());
            }
            catch (CoreException coreException) {
                log.error("Error creating extension '{}' for extension point '{}'.", new Object[]{iConfigurationElement.getContributor().getName(), string, coreException});
            }
            ++n2;
        }
        arrayList.trimToSize();
        this.implementations = Collections.unmodifiableList(arrayList);
    }

    public List<T> getExtensions() {
        return this.implementations;
    }
}

