/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.extensions;

import com.agfa.pacs.logging.ALogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SingletonExtensionFactory<T> {
    private static final ALogger log = ALogger.getLogger(SingletonExtensionFactory.class);
    private final T implementation;

    public SingletonExtensionFactory(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(string);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        if (iConfigurationElementArray == null || iConfigurationElementArray.length != 1) {
            StringBuilder stringBuilder = this.getDetailedErrorMessage(iConfigurationElementArray);
            throw new IllegalStateException("There should be exactly one implementation for extension point " + string + ": " + stringBuilder.toString());
        }
        try {
            Object object = iConfigurationElementArray[0].createExecutableExtension("class");
            log.info("Extension point '{}' implemented by {}", (Object)string, object.getClass());
            this.implementation = object;
        }
        catch (CoreException coreException) {
            throw new IllegalStateException(coreException);
        }
    }

    private StringBuilder getDetailedErrorMessage(IConfigurationElement[] iConfigurationElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iConfigurationElementArray == null) {
            stringBuilder.append("no extensions found");
        } else {
            stringBuilder.append(iConfigurationElementArray.length).append(" extensions found. ");
            if (iConfigurationElementArray.length > 0) {
                stringBuilder.append("Contributors: ").append(System.lineSeparator());
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                    stringBuilder.append("    ").append(iConfigurationElement.getContributor().getName()).append(System.lineSeparator());
                    ++n2;
                }
            }
        }
        return stringBuilder;
    }

    public T getInstance() {
        return this.implementation;
    }
}

