/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.inputhandler;

import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class BindingUtils {
    private static final ALogger LOGGER = ALogger.getLogger(BindingUtils.class);
    public static final char DEVICEID_CHANNEL_DELIMITER = ':';
    public static final char DEVCHANNELS_DELIMITER = '+';
    public static final char ACTION_DEVCHANNELS_DELIMITER = '/';
    public static final char ACTION_DEVCHANNELS_START_DELIMITER = '(';
    public static final char ACTION_DEVCHANNELS_END_DELIMITER = ')';
    public static final String KEYBOARD_DEVICE_IDENTIFIER = "Keyboard";
    public static final String KEY_CONTROL = "Key_CONTROL";
    public static final String KEY_LEFT_CONTROL = "Key_LEFT_CONTROL";
    public static final String KEY_RIGHT_CONTROL = "Key_RIGHT_CONTROL";
    public static final String KEY_ALT = "Key_ALT";
    public static final String KEY_LEFT_ALT = "Key_LEFT_ALT";
    public static final String KEY_RIGHT_ALT = "Key_RIGHT_ALT";
    public static final String KEY_SHIFT = "Key_SHIFT";
    public static final String KEY_RIGHT_SHIFT = "Key_RIGHT_SHIFT";
    public static final String KEY_LEFT_SHIFT = "Key_LEFT_SHIFT";
    public static final String KEY_WINDOWS = "Key_WINDOWS";
    public static final String KEY_RIGHT_WINDOWS = "Key_RIGHT_WINDOWS";
    public static final String KEY_LEFT_WINDOWS = "Key_LEFT_WINDOWS";
    public static final String KEY_CONTEXT_MENU = "Key_CONTEXT_MENU";
    public static final String KEY_META = "Key_META";
    public static final String KEY_RIGHT_META = "Key_RIGHT_META";
    public static final String KEY_LEFT_META = "Key_LEFT_META";
    public static final Pattern PATTERN_F_KEYS = Pattern.compile("^Key_F[0-9]{1,2}$");
    public static final List<String> KEYBOARD_MODIFIER_KEYS;
    private static final String[] KEYBOARD_MODIFIER_KEY_ARRAY;
    private static final List<String> KEYBOARD_MODIFIER_KEY_LIST;

    static {
        KEYBOARD_MODIFIER_KEY_ARRAY = new String[]{KEY_CONTROL, KEY_RIGHT_CONTROL, KEY_LEFT_CONTROL, KEY_ALT, KEY_RIGHT_ALT, KEY_LEFT_ALT, KEY_SHIFT, KEY_RIGHT_SHIFT, KEY_LEFT_SHIFT, KEY_WINDOWS, KEY_RIGHT_WINDOWS, KEY_LEFT_WINDOWS, KEY_CONTEXT_MENU, KEY_META, KEY_RIGHT_META, KEY_LEFT_META};
        KEYBOARD_MODIFIER_KEY_LIST = new ArrayList<String>();
        String[] stringArray = KEYBOARD_MODIFIER_KEY_ARRAY;
        int n = KEYBOARD_MODIFIER_KEY_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            KEYBOARD_MODIFIER_KEY_LIST.add(string);
            ++n2;
        }
        KEYBOARD_MODIFIER_KEYS = Collections.unmodifiableList(KEYBOARD_MODIFIER_KEY_LIST);
    }

    private BindingUtils() {
    }

    public static String parseDeviceIDFromDevChannelID(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            LOGGER.error("bad devChannel argument '{}'", (Object)string);
            return null;
        }
        return string.substring(0, n);
    }

    public static String parseChannelIDFromDevChannelID(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            LOGGER.error("bad devChannel argument '{}'", (Object)string);
            return null;
        }
        return string.substring(n + 1);
    }

    public static String parseActionChannelFromSerializedBinding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get the action channel of a null string");
        }
        int n = string.lastIndexOf(43);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static List<String> parseModifiersFromSerializedBinding(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf('+'));
        try {
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n - 1) {
                arrayList.add(stringTokenizer.nextToken());
                ++n2;
            }
        }
        catch (Exception exception) {
            LOGGER.error("error parsing assignment combination '{}'", (Object)string, (Object)exception);
        }
        return arrayList;
    }

    public static List<String> parseActionChannelsFromSerializedBinding(String string) {
        int n;
        if (string == null) {
            return Collections.emptyList();
        }
        String string2 = String.valueOf(String.valueOf('+')) + String.valueOf('(') + String.valueOf(')');
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        try {
            int n2 = stringTokenizer.countTokens();
            n = 0;
            while (n < n2 - 1) {
                stringTokenizer.nextToken();
                ++n;
            }
            string3 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            LOGGER.error("error parsing assignment combination '{}'", (Object)string, (Object)exception);
        }
        stringTokenizer = new StringTokenizer(string3, String.valueOf('/'));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            n = stringTokenizer.countTokens();
            int n3 = 0;
            while (n3 < n) {
                arrayList.add(stringTokenizer.nextToken());
                ++n3;
            }
        }
        catch (Exception exception) {
            LOGGER.error("error parsing assignment combination '{}'", (Object)string, (Object)exception);
        }
        return arrayList;
    }

    public static String buildDeviceChannelID(String string, String string2) {
        return String.valueOf(string) + ':' + string2;
    }
}

