/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.inputhandler;

import com.agfa.pacs.inputhandler.Binding;
import com.agfa.pacs.inputhandler.IInputChannel;
import com.agfa.pacs.inputhandler.IShortcutBinding;
import java.util.Objects;

public class ShortcutBinding
extends Binding
implements IShortcutBinding {
    private static final long serialVersionUID = 7259343443556410704L;
    final IInputChannel actionTrigger;

    public ShortcutBinding(IInputChannel[] iInputChannelArray, IInputChannel iInputChannel) {
        super(iInputChannelArray);
        this.actionTrigger = iInputChannel;
    }

    @Override
    public IInputChannel getActionTrigger() {
        return this.actionTrigger;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.equals(Binding.EMPTY_SHORTCUT_BINDING)) {
            this.label = "";
            return this.label;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.modifiers != null) {
            int n = 0;
            while (n < this.modifiers.length) {
                String string = this.modifiers[n].getLabel();
                stringBuilder.append(string).append('+');
                ++n;
            }
        }
        if (this.actionTrigger != null) {
            stringBuilder.append(this.actionTrigger.getLabel());
        }
        this.label = stringBuilder.toString();
        return this.label;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ShortcutBinding)) {
            return false;
        }
        ShortcutBinding shortcutBinding = (ShortcutBinding)object;
        return Objects.deepEquals(this.sortedModifiers, shortcutBinding.getSortedModifiers()) && Objects.equals(this.actionTrigger, shortcutBinding.getActionTrigger());
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == -1) {
            n = 0;
            if (this.actionTrigger != null) {
                n = this.actionTrigger.hashCode();
            }
            if (this.sortedModifiers != null) {
                IInputChannel[] iInputChannelArray = this.sortedModifiers;
                int n2 = this.sortedModifiers.length;
                int n3 = 0;
                while (n3 < n2) {
                    IInputChannel iInputChannel = iInputChannelArray[n3];
                    n = 31 * n + iInputChannel.hashCode();
                    ++n3;
                }
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.modifiers != null) {
            IInputChannel[] iInputChannelArray = this.modifiers;
            int n = this.modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                IInputChannel iInputChannel = iInputChannelArray[n2];
                stringBuilder.append(iInputChannel.getDeviceChannelID());
                stringBuilder.append('+');
                ++n2;
            }
        }
        if (this.actionTrigger != null) {
            stringBuilder.append(this.actionTrigger.getDeviceChannelID());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean usesChannelOfDevice(String string) {
        if (super.usesChannelOfDevice(string)) {
            return true;
        }
        return this.actionTrigger != null && this.actionTrigger.getDeviceID().equals(string);
    }
}

