/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.messages;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.messages.UnicodeResourceClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SharedMessages {
    public static final char MISSING_MESSAGE_MARKER = '!';
    public static final String MINICORE_MESSAGE_START_MARKER = "(!)";
    public static final String MINICORE_MESSAGE_END_MARKER = "(/!)";
    public static final String MINICORE_PARAMETERS_START_MARKER = "(?)";
    public static final String MINICORE_PARAMETERS_END_MARKER = "(/?)";
    private static final String SHARED_MESSAGES_BUNDLE_NAME = "shared.messages";
    private static final String MINICORE_SHARED_MESSAGES_BUNDLE_NAME = "com.agfa.pacs.minicore.messages";
    protected static final String DEFAULT_BUNDLE_NAME = "messages";
    private static final String USE_MINICORE_LOCALIZATION_CONFIG_KEY = "com.agfa.pacs.messages.useMinicoreLocalization";
    protected static final ALogger log = ALogger.getLogger(SharedMessages.class);
    private static final boolean useMinicoreLocalization = ConfigurationProviderFactory.getConfig().getBoolean("com.agfa.pacs.messages.useMinicoreLocalization");
    private static final ResourceBundle RESOURCE_BUNDLE = !useMinicoreLocalization ? ResourceBundle.getBundle("shared.messages", Locale.getDefault(), new UnicodeResourceClassLoader(SharedMessages.class.getClassLoader())) : ResourceBundle.getBundle("com.agfa.pacs.minicore.messages", Locale.getDefault(), new UnicodeResourceClassLoader(SharedMessages.class.getClassLoader()));

    public static ResourceBundle getBundle(String string, Locale locale, Class<?> clazz) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, new UnicodeResourceClassLoader(clazz.getClassLoader()));
            return resourceBundle;
        }
        catch (Exception exception) {
            if (!useMinicoreLocalization) {
                log.error("Resource bundle for package '{}' not found", (Object)clazz.getPackage(), (Object)exception);
            }
            return null;
        }
    }

    public static ResourceBundle getBundle(String string, Class<?> clazz) {
        return SharedMessages.getBundle(string, Locale.getDefault(), clazz);
    }

    public static ResourceBundle getBundle(Class<?> clazz) {
        return SharedMessages.getBundle(DEFAULT_BUNDLE_NAME, Locale.getDefault(), clazz);
    }

    private static String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if ((string2 = SharedMessages.getString(string)) == null) {
            if (!useMinicoreLocalization) {
                log.warn("Missing key '{}'", (Object)string);
                return String.valueOf('!') + string + '!';
            }
            return MINICORE_MESSAGE_START_MARKER + string + MINICORE_MESSAGE_END_MARKER;
        }
        return string2;
    }

    public static String getString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        String string2 = SharedMessages.getString(resourceBundle, string);
        string2 = MessageFormat.format(string2, objectArray);
        if (useMinicoreLocalization && objectArray.length > 0) {
            string2 = SharedMessages.appendParametersToMessage(string2, objectArray);
        }
        return string2;
    }

    private static String appendParametersToMessage(String string, Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            stringBuffer.append(MINICORE_PARAMETERS_START_MARKER);
            stringBuffer.append(object.toString());
            stringBuffer.append(MINICORE_PARAMETERS_END_MARKER);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getStringNoLog(ResourceBundle resourceBundle, String string) {
        return SharedMessages.getStringNoLog(resourceBundle, string, string);
    }

    public static String getStringNoLog(ResourceBundle resourceBundle, String string, String string2) {
        if (resourceBundle == null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = resourceBundle.getString(string);
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            string3 = SharedMessages.getString(string);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }
    }
}

