/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.messages;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.UnicodeReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeResourceClassLoader
extends ClassLoader {
    private static final ALogger LOGGER = ALogger.getLogger(UnicodeResourceClassLoader.class);
    private final ClassLoader delegate;

    public UnicodeResourceClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.delegate = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        ByteArrayInputStream byteArrayInputStream;
        UnicodeReader unicodeReader;
        block33: {
            InputStream inputStream = this.delegate.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            unicodeReader = new UnicodeReader(inputStream, null);
            char[] cArray = new char[1024];
            Throwable throwable2 = null;
            Object var9_13 = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
            try {
                int n;
                while ((n = unicodeReader.read(cArray)) > 0) {
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if ((c & 0xFFFF) < 256) {
                            byteArrayOutputStream.write(c & 0xFF);
                        } else {
                            byteArrayOutputStream.write(UnicodeResourceClassLoader.getUtf8Encoding(c).getBytes());
                        }
                        ++n2;
                    }
                }
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                if (byteArrayOutputStream == null) break block33;
            }
            catch (Throwable throwable3) {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    try {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Error occured in UnicodeResourceClassLoader.getResourceAsStream() when reading from input stream {}", (Throwable)iOException);
                        if (unicodeReader != null) {
                            unicodeReader.close();
                        }
                        try {
                            return null;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (unicodeReader != null) {
                                    unicodeReader.close();
                                }
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (throwable == null) {
                                        throwable = throwable6;
                                    } else if (throwable != throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    throw throwable;
                                }
                                catch (IOException iOException2) {
                                    LOGGER.error("Error occured in UnicodeResourceClassLoader.getResourceAsStream() when closing the input stream {}", (Throwable)iOException2);
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
            byteArrayOutputStream.close();
        }
        if (unicodeReader != null) {
            unicodeReader.close();
        }
        return byteArrayInputStream;
    }

    private static String getUtf8Encoding(char c) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("\\u");
        String string = Integer.toString(c, 16);
        int n = string.length();
        while (n < 4) {
            stringBuilder.append('0');
            ++n;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

