/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.notifications;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import java.io.Serializable;

public class Notification
implements Serializable {
    private static final long serialVersionUID = 3173381245324547290L;
    private static final int NOTIFICATION_EVENT = EventEngineFactory.getInstance().getEventID("notification.message");
    private final Level level;
    private final String category;
    private final String id;
    private final String briefMgs;
    private final String verboseMsg;
    private final String continueLabel;
    private final String abortLabel;
    private String[] trace;
    private boolean showAbortButton = true;

    public Notification(Level level, String string, String string2, String string3, String string4) {
        this(level, string, string2, string3, string4, null, null);
    }

    public Notification(Level level, String string, String string2, String string3, String string4, String string5, String string6) {
        this.level = level;
        this.category = string;
        this.id = string2;
        this.briefMgs = string3;
        this.verboseMsg = string4;
        this.continueLabel = string5;
        this.abortLabel = string6;
    }

    public Notification(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        this(level, string, string2, string3, string4, null, null, throwable);
    }

    public Notification(Level level, String string, String string2, String string3, String string4, String string5, String string6, Throwable throwable) {
        this(level, string, string2, string3, string4, string5, string6);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.trace = new String[stackTraceElementArray.length + 1];
        this.trace[0] = throwable.getMessage();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            this.trace[n + 1] = stackTraceElementArray[n].toString();
            ++n;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getBriefMgs() {
        return this.briefMgs;
    }

    public String getVerboseMsg() {
        return this.verboseMsg;
    }

    public String[] getTrace() {
        return this.trace;
    }

    public String getContinueLabel() {
        return this.continueLabel;
    }

    public String getAbortLabel() {
        return this.abortLabel;
    }

    public void send() {
        IEvent iEvent = EventEngineFactory.getInstance().createInternalEvent(NOTIFICATION_EVENT);
        iEvent.setDestination(null, "notifications");
        iEvent.setPayload(this);
        iEvent.setActionInfo(ActionInfo.SINGLE);
        EventEngineFactory.getInstance().sendStreamEvent(iEvent);
    }

    public boolean isMoreSevere(Notification notification) {
        if (notification == null) {
            return true;
        }
        return this.getLevel().ordinal() > notification.getLevel().ordinal();
    }

    public boolean showAbortButton() {
        return this.showAbortButton;
    }

    public void showAbortButton(boolean bl) {
        this.showAbortButton = bl;
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR,
        CRITICAL;

    }
}

