/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.options;

import com.agfa.pacs.options.IOptionsPanelCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class OptionsPanelCreatorFactory {
    private static final String EXTENSION_POINT = "com.agfa.pacs.core.shared.OptionsPanelCreator";
    private final List<IOptionsPanelCreator> creators = new ArrayList<IOptionsPanelCreator>();
    private static final OptionsPanelCreatorFactory INSTANCE = new OptionsPanelCreatorFactory();

    public static OptionsPanelCreatorFactory getInstance() {
        return INSTANCE;
    }

    public List<IOptionsPanelCreator> getOptionsPanelCreators() {
        return this.creators;
    }

    private OptionsPanelCreatorFactory() {
        this.loadExtensions(EXTENSION_POINT);
    }

    private void loadExtensions(String string) {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                IOptionsPanelCreator iOptionsPanelCreator3 = (IOptionsPanelCreator)iConfigurationElement.createExecutableExtension("class");
                this.creators.add(iOptionsPanelCreator3);
            }
            catch (CoreException coreException) {
                throw new RuntimeException(coreException);
            }
            ++n2;
        }
        Collections.sort(this.creators, (iOptionsPanelCreator, iOptionsPanelCreator2) -> iOptionsPanelCreator2.getSortingPriority() - iOptionsPanelCreator.getSortingPriority());
    }
}

