/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.security;

import com.agfa.pacs.core.FactoryInitializationFailedException;
import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.security.ISecurityManager;

public abstract class SecurityManagerFactory {
    private static SecurityManagerFactory instance = SecurityManagerFactory.initialize();
    protected ISecurityManager securityManagerExtension;

    public static SecurityManagerFactory getInstance() {
        return instance;
    }

    public SecurityManagerFactory() {
        this.initSecurityManager();
    }

    public ISecurityManager getSecurityManager() {
        return this.securityManagerExtension;
    }

    private static synchronized SecurityManagerFactory initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(SecurityManagerFactory.class.getName()));
            return (SecurityManagerFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        throw new FactoryInitializationFailedException(SecurityManagerFactory.class.getName(), reflectiveOperationException);
    }

    protected abstract void initSecurityManager();
}

