/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.security;

import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.ISecurityManager;
import com.agfa.pacs.security.SecurityManagerFactory;
import org.apache.log4j.LogManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.adaptor.EclipseStarter;

public class SecurityManagerFactoryEclipseImpl
extends SecurityManagerFactory {
    private static final ALogger LOGGER = ALogger.getLogger(SecurityManagerFactoryEclipseImpl.class);
    private static final boolean IS_AGILITY = ApplicationManagement.getInstance().getApplicationType().isAgility();

    @Override
    protected void initSecurityManager() {
        try {
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.agfa.pacs.core.shared.SecurityServiceProvider");
            if (iConfigurationElementArray.length == 1) {
                Object object = iConfigurationElementArray[0].createExecutableExtension("class");
                if (object instanceof ISecurityManager) {
                    this.securityManagerExtension = (ISecurityManager)object;
                }
            } else if (IS_AGILITY) {
                SecurityManagerFactoryEclipseImpl.shutdownSoftware();
            } else {
                this.securityManagerExtension = new ISecurityManager(){

                    @Override
                    public String getSecurityToken() {
                        return null;
                    }
                };
            }
        }
        catch (CoreException coreException) {
            LOGGER.error("Can not instantiate Extension of ExtensionPoint: com.agfa.pacs.core.shared.SecurityServiceProvider", (Throwable)coreException);
        }
    }

    private static void shutdownSoftware() {
        LOGGER.error("[FATAL] NO SECURITY MANAGER EXTENSION FOUND. Exactly one plugin needs to extend the SecurityServiceProvider extension point.");
        LogManager.shutdown();
        try {
            EclipseStarter.shutdown();
        }
        catch (Exception exception) {
            System.exit(-99);
        }
    }
}

