/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.sharedgui;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.sharedgui.ISharedGUIProvider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public abstract class SharedGUIFactory {
    private static final ALogger LOGGER = ALogger.getLogger(SharedGUIFactory.class);
    private static final String DOMAIN_ATTRIBUTE = "domain";
    protected static Map<String, ISharedGUIProvider> providers = new HashMap<String, ISharedGUIProvider>();

    static {
        SharedGUIFactory.initialize();
    }

    public static JComponent getWidgetInstance(String string) {
        return SharedGUIFactory.getWidgetInstance(string, null);
    }

    public static JComponent getWidgetInstance(String string, Map<String, Object> map) {
        int n = string.indexOf(46);
        if (n == -1) {
            throw new IllegalArgumentException("Illegal name '" + string + "'. It must have a prefix and suffix separated with a dot (.)");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ISharedGUIProvider iSharedGUIProvider = providers.get(string2);
        if (iSharedGUIProvider == null) {
            throw new IllegalArgumentException("No SharedGUIProvider with prefix '" + string2 + "' found. (Name: '" + string + "')");
        }
        if (map != null) {
            return iSharedGUIProvider.createWidgetInstance(string3, map);
        }
        return iSharedGUIProvider.createWidgetInstance(string3);
    }

    private static void initialize() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.core.shared.SharedGUI");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = iConfigurationElement.getAttribute(DOMAIN_ATTRIBUTE);
            ISharedGUIProvider iSharedGUIProvider = providers.put(string, new SharedGUIProviderEclipseProxy(iConfigurationElement));
            if (iSharedGUIProvider != null) {
                LOGGER.error("Duplicate SharedGUIProvider for domain: {}", (Object)string);
            }
            ++n2;
        }
    }

    private static class SharedGUIProviderEclipseProxy
    implements ISharedGUIProvider {
        private final IConfigurationElement ce;
        private ISharedGUIProvider delegate;

        public SharedGUIProviderEclipseProxy(IConfigurationElement iConfigurationElement) {
            this.ce = iConfigurationElement;
        }

        @Override
        public JComponent createWidgetInstance(String string, Map<String, Object> map) {
            this.createDelegateIfNecessary();
            if (this.delegate == this) {
                return null;
            }
            return this.delegate.createWidgetInstance(string, map);
        }

        @Override
        public JComponent createWidgetInstance(String string) {
            this.createDelegateIfNecessary();
            if (this.delegate == this) {
                return null;
            }
            return this.delegate.createWidgetInstance(string);
        }

        private void createDelegateIfNecessary() {
            if (this.delegate == null) {
                try {
                    this.delegate = (ISharedGUIProvider)this.ce.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    this.delegate = this;
                    LOGGER.error("Creating extension failed for '{}'", (Object)this.ce.getAttribute(SharedGUIFactory.DOMAIN_ATTRIBUTE), (Object)coreException);
                }
            }
        }
    }
}

