/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.systemsettings;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.systemsettings.ICoreSystemSettings;

public abstract class SystemSettingsFactory {
    protected static final ALogger logger = ALogger.getLogger(SystemSettingsFactory.class);
    private static final SystemSettingsFactory implementation = SystemSettingsFactory.initialize();
    protected ICoreSystemSettings settings;

    public static SystemSettingsFactory getInstance() {
        return implementation;
    }

    private static synchronized SystemSettingsFactory initialize() {
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(SystemSettingsFactory.class.getName()));
            return (SystemSettingsFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException("failed to create registry " + SystemSettingsFactory.class.getName(), reflectiveOperationException);
        }
    }

    protected SystemSettingsFactory() {
    }

    public ICoreSystemSettings getSystemSettings() {
        return this.settings;
    }
}

