/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Activator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleContext {
    private static final ALogger log = ALogger.getLogger(BundleContext.class);
    private static BundleContext implementation = new BundleContext();

    private BundleContext() {
    }

    public String getClassBundleName(Class<?> clazz) {
        return FrameworkUtil.getBundle(clazz).getSymbolicName();
    }

    public List<String> getRequiredPlugins(String string) {
        BundleDescription[] bundleDescriptionArray = Platform.getPlatformAdmin().getState(false).getBundles(string);
        if (bundleDescriptionArray.length != 1) {
            log.error("Dependency problem:" + string);
            return Collections.emptyList();
        }
        BundleDescription bundleDescription = bundleDescriptionArray[0];
        LinkedList<String> linkedList = new LinkedList<String>();
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification bundleSpecification = bundleSpecificationArray[n2];
            String string2 = bundleSpecification.getName();
            if (!string2.startsWith("org.eclipse") && !string2.startsWith("fucking")) {
                linkedList.add(string2);
            }
            ++n2;
        }
        return linkedList;
    }

    public String getPluginName(long l) {
        if (l == 0L) {
            return "shared";
        }
        Bundle bundle = Activator.getContext().getBundle(l);
        if (bundle == null) {
            return "unresolvable";
        }
        return bundle.getSymbolicName();
    }

    public Class<?> loadClassFromBundle(long l, String string) throws ClassNotFoundException, IllegalArgumentException {
        Bundle bundle = Activator.getContext().getBundle(l);
        if (bundle != null) {
            return bundle.loadClass(String.valueOf(bundle.getSymbolicName()) + "." + string);
        }
        throw new IllegalArgumentException("Bundle unresolvable");
    }

    public String getPluginVersion(String string) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return "1.0.0";
        }
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public long getBundleId(String string) {
        if ("shared".equals(string)) {
            return 0L;
        }
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return -1L;
        }
        return bundle.getBundleId();
    }

    public Bundle getBundle(Class<?> clazz) {
        try {
            String string = this.getClassBundleName(clazz);
            return Platform.getBundle((String)string);
        }
        catch (Error error) {
            log.error("Could not retrieve Bundle", (Throwable)error);
            return null;
        }
    }

    public static BundleContext getBundleContext() {
        return implementation;
    }
}

