/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import java.util.Comparator;

public class DoubleEquals
implements Comparator<Double> {
    public static final double DEFAULT_DELTA = 1.0E-6;
    private final double delta;

    private DoubleEquals(double d) {
        this.delta = d;
    }

    public static Comparator<Double> getComparator() {
        return DoubleEquals.getComparator(1.0E-6);
    }

    public static Comparator<Double> getComparator(double d) {
        return new DoubleEquals(d);
    }

    public static boolean equals(double d, double d2) {
        return DoubleEquals.equals(d, d2, 1.0E-6);
    }

    public static boolean equals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    @Override
    public int compare(Double d, Double d2) {
        if (DoubleEquals.equals(d, d2, this.delta)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        return DoubleEquals.equals(dArray, dArray2, 1.0E-6);
    }

    public static boolean equals(double[] dArray, double[] dArray2, double d) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            if (!DoubleEquals.equals(dArray[n], dArray2[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

