/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.services.AsyncTaskThreadPool;
import com.agfa.pacs.tools.PriorityQueue;
import java.util.ArrayList;
import java.util.List;

public class GlobalQueueController {
    private static final int LIMIT_PREVENT_ALL = 1;
    private static final int LIMIT_VISIBLE_ONLY = 3;
    private static final int LIMIT_NO_BULK = 10;
    private static final int LIMIT_NO_LIMIT = 32;
    private static List<PriorityQueue<? extends Object>> queues = new ArrayList<PriorityQueue<? extends Object>>();
    private static int lockModeRequests;
    private static boolean displayModeRequests;
    private static boolean userInteraction;
    private static int limitLevel;
    private static int INACTIVITY_TIMEOUT;
    private static InteractionTimeout timer;

    static {
        limitLevel = 32;
        INACTIVITY_TIMEOUT = 1000;
        timer = new InteractionTimeout();
    }

    public static synchronized void addQueue(PriorityQueue<? extends Object> priorityQueue) {
        queues.add(priorityQueue);
        priorityQueue.setConsumptionThreshold(limitLevel);
    }

    public static synchronized void preventAllConsumption(boolean bl) {
        if (bl) {
            if (++lockModeRequests == 1) {
                GlobalQueueController.switchMode();
            }
        } else if (--lockModeRequests == 0) {
            GlobalQueueController.switchMode();
        }
    }

    public static synchronized void restrictToVisibleImages(boolean bl) {
        displayModeRequests = bl;
        boolean bl2 = displayModeRequests;
        if (displayModeRequests ^ bl2) {
            GlobalQueueController.switchMode();
        }
        if (!displayModeRequests) {
            GlobalQueueController.setUserInteractionOngoing();
        }
    }

    public static synchronized void setUserInteractionOngoing() {
        boolean bl = userInteraction;
        userInteraction = true;
        GlobalQueueController.resetTimer();
        if (!bl) {
            GlobalQueueController.switchMode();
        }
    }

    private static void resetTimer() {
        timer.reset();
    }

    private static void switchMode() {
        int n = 0;
        n = lockModeRequests > 0 ? 1 : (displayModeRequests ? 3 : (userInteraction ? 10 : 32));
        if (n != limitLevel) {
            limitLevel = n;
            int n2 = 0;
            while (n2 < queues.size()) {
                queues.get(n2).setConsumptionThreshold(n);
                ++n2;
            }
        }
    }

    public static synchronized boolean isLimited() {
        return limitLevel != 32;
    }

    private static class InteractionTimeout
    implements Runnable {
        private boolean isRunning;
        private long timeoutAt;

        private InteractionTimeout() {
        }

        @Override
        public synchronized void run() {
            while (System.currentTimeMillis() < this.timeoutAt) {
                try {
                    this.wait(Math.max(this.timeoutAt - System.currentTimeMillis(), 0L));
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isRunning = false;
            userInteraction = false;
            GlobalQueueController.switchMode();
        }

        public synchronized void reset() {
            this.timeoutAt = System.currentTimeMillis() + (long)INACTIVITY_TIMEOUT;
            if (!this.isRunning) {
                this.isRunning = true;
                AsyncTaskThreadPool.getInstance().executeUnchecked((Runnable)this);
            }
        }
    }
}

