/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Pattern {
    public static final java.util.regex.Pattern DOT = java.util.regex.Pattern.compile("\\.");
    public static final java.util.regex.Pattern EQUAL = java.util.regex.Pattern.compile("=");
    public static final java.util.regex.Pattern COMMA = java.util.regex.Pattern.compile(",");
    public static final java.util.regex.Pattern SPACE = java.util.regex.Pattern.compile(" ");
    public static final java.util.regex.Pattern AMPERSAND = java.util.regex.Pattern.compile("&");
    public static final java.util.regex.Pattern ASTERISK = java.util.regex.Pattern.compile("\\*");
    public static final java.util.regex.Pattern SEMI_COLON = java.util.regex.Pattern.compile(";");
    public static final java.util.regex.Pattern BACK_SLASH = java.util.regex.Pattern.compile("\\\\");
    public static final java.util.regex.Pattern PLUS = java.util.regex.Pattern.compile("\\+");
    public static final java.util.regex.Pattern MINUS = java.util.regex.Pattern.compile("\\-");
    public static final java.util.regex.Pattern COLON = java.util.regex.Pattern.compile(":");
    public static final java.util.regex.Pattern CR_LF = java.util.regex.Pattern.compile("\r\n");
    public static final java.util.regex.Pattern NEWLINE = java.util.regex.Pattern.compile("\n");
    public static final java.util.regex.Pattern PATH_SEPERATOR = java.util.regex.Pattern.compile(File.pathSeparator);
    public static final java.util.regex.Pattern SLASH = java.util.regex.Pattern.compile("/");
    public static final java.util.regex.Pattern PIPE = java.util.regex.Pattern.compile("\\|");
    public static final java.util.regex.Pattern DS = java.util.regex.Pattern.compile("ds");
    public static final java.util.regex.Pattern UNDERSCORE = java.util.regex.Pattern.compile("_");
    public static final java.util.regex.Pattern HASH = java.util.regex.Pattern.compile("#");
    public static final java.util.regex.Pattern DOLLAR = java.util.regex.Pattern.compile("\\$");
    public static final char WILDCARD_CHARACTER = '*';
    public static final char WILDCARD_ESCAPE_CHARACTER = '\\';
    private static final String WILDCARD_CHARACTER_STRING = Character.toString('*');
    private static final String WILDCARD_ESCAPE_CHARACTER_STRING = Character.toString('\\');
    private static final String ESCAPED_WILDCARD_CHARACTER_STRING = String.valueOf(WILDCARD_ESCAPE_CHARACTER_STRING) + WILDCARD_CHARACTER_STRING;
    private static final String ESCAPED_WILDCARD_ESCAPE_CHARACTER_STRING = String.valueOf(WILDCARD_ESCAPE_CHARACTER_STRING) + WILDCARD_ESCAPE_CHARACTER_STRING;
    private static final Map<String, java.util.regex.Pattern> cachedCustomPatterns = new HashMap<String, java.util.regex.Pattern>();
    public static final String DICOM_REGEX_GROUP = "group";
    public static final String DICOM_REGEX_ELEMENT = "element";
    public static final String DICOM_REGEX_CREATOR = "creator";
    public static final java.util.regex.Pattern dicomTag = java.util.regex.Pattern.compile("\\(\\s*(?<group>[0-9a-fA-F]{4})\\s*,\\s*(?<element>[0-9a-fA-F]{4})\\s*(,\\s*\"(?<creator>.*)\"\\s*)?\\)");

    public static java.util.regex.Pattern getPattern(String string) {
        if (".".equals(string)) {
            return DOT;
        }
        if ("=".equals(string)) {
            return EQUAL;
        }
        if (",".equals(string)) {
            return COMMA;
        }
        if (" ".equals(string)) {
            return SPACE;
        }
        if ("&".equals(string)) {
            return AMPERSAND;
        }
        if ("*".equals(string)) {
            return ASTERISK;
        }
        if (";".equals(string)) {
            return SEMI_COLON;
        }
        if ("\\".equals(string)) {
            return BACK_SLASH;
        }
        if ("+".equals(string)) {
            return PLUS;
        }
        if ("-".equals(string)) {
            return MINUS;
        }
        if (":".equals(string)) {
            return COLON;
        }
        if ("\r\n".equals(string)) {
            return CR_LF;
        }
        if ("\n".equals(string)) {
            return NEWLINE;
        }
        if (File.pathSeparator.equals(string)) {
            return PATH_SEPERATOR;
        }
        if ("/".equals(string)) {
            return SLASH;
        }
        if ("|".equals(string)) {
            return PIPE;
        }
        if ("ds".equals(string)) {
            return DS;
        }
        if ("_".equals(string)) {
            return UNDERSCORE;
        }
        if ("#".equals(string)) {
            return HASH;
        }
        java.util.regex.Pattern pattern = cachedCustomPatterns.get(string);
        if (pattern == null) {
            pattern = java.util.regex.Pattern.compile(java.util.regex.Pattern.quote(string));
            cachedCustomPatterns.put(string, pattern);
        }
        return pattern;
    }

    public static boolean containsWildcards(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                } else if (c == '*') {
                    return true;
                }
            } else {
                bl = false;
            }
            ++n;
        }
        return false;
    }

    public static String escapeWildcards(String string) {
        return string.replace(WILDCARD_ESCAPE_CHARACTER_STRING, ESCAPED_WILDCARD_ESCAPE_CHARACTER_STRING).replace(WILDCARD_CHARACTER_STRING, ESCAPED_WILDCARD_CHARACTER_STRING);
    }

    public static String unescapeWildcards(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!bl && c == '\\' && n + 1 < string.length() && Pattern.isCharacterThatNeedsToBeEscaped(string.charAt(n + 1))) {
                bl = true;
            } else {
                if (!bl && c == '*') {
                    throw new IllegalArgumentException("The string '" + string + "' contains unescaped wildcards");
                }
                stringBuilder.append(c);
                bl = false;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static boolean isCharacterThatNeedsToBeEscaped(char c) {
        return c == '\\' || c == '*';
    }

    public static String wildcardToRegularExpression(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\Q");
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!bl && c == '\\' && n + 1 < string.length() && Pattern.isCharacterThatNeedsToBeEscaped(string.charAt(n + 1))) {
                bl = true;
            } else if (!bl && c == '*') {
                stringBuilder.append("\\E");
                stringBuilder.append(".*");
                stringBuilder.append("\\Q");
                bl2 = false;
            } else if (c == 'E' && bl2) {
                stringBuilder.append("\\E\\QE");
                bl2 = false;
                bl = false;
            } else {
                stringBuilder.append(c);
                bl2 = c == '\\';
                bl = false;
            }
            ++n;
        }
        stringBuilder.append("\\E");
        return stringBuilder.toString();
    }

    public static String toCaseInsensitivePattern(String string) {
        return "(?iu)" + string;
    }
}

