/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.tools.IRequestQueueVisitor;
import java.util.HashMap;
import java.util.Iterator;

public class PriorityQueue<P> {
    public static final int DEFAULT_NUM_PRIORITIES = 21;
    public static final int DEFAULT_IDLE_THRESHOLD = 2;
    protected QueueEntry<P>[] queues;
    protected int itemPresenceMask = 0;
    protected HashMap<Object, QueueEntry<P>> entries = new HashMap();
    protected int consumptionThreshold;
    private int cthBackup;

    private void initialize(int n, int n2) {
        if (n <= 0 || n >= 32) {
            throw new IllegalArgumentException("numPriorities " + n + " is not legal.  It must be >0 and <32");
        }
        this.queues = new QueueEntry[n];
        int n3 = 0;
        while (n3 < this.queues.length) {
            this.queues[n3] = new QueueEntry(n3);
            this.queues[n3].next = this.queues[n3];
            ((QueueEntry)this.queues[n3]).previous = (QueueEntry)this.queues[n3];
            ++n3;
        }
        this.consumptionThreshold = 32;
    }

    public PriorityQueue() {
        this.initialize(21, 2);
    }

    public PriorityQueue(int n, int n2) {
        this.initialize(n, n2);
    }

    public int getNumberOfPriorities() {
        return this.queues.length;
    }

    public synchronized boolean addAtTop(P p, int n) {
        return this.addAtTopIfNotExists(p, n) != null;
    }

    public synchronized P addAtTopIfNotExists(P p, int n) {
        n = this.validatePriority(n);
        QueueEntry<Object> queueEntry = this.entries.get(p);
        if (queueEntry != null) {
            queueEntry.remove();
            if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
            }
            queueEntry.priority = n;
            queueEntry.insertAfter(this.queues[n]);
            this.itemPresenceMask |= 1 << 31 - n;
            this.notifyAll();
            return (P)queueEntry.payload;
        }
        queueEntry = new QueueEntry(p, p, n);
        this.entries.put(p, queueEntry);
        queueEntry.insertAfter(this.queues[n]);
        this.itemPresenceMask |= 1 << 31 - n;
        this.notifyAll();
        return null;
    }

    private int validatePriority(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.queues.length) {
            return this.queues.length - 1;
        }
        return n;
    }

    public synchronized boolean addAtBottom(P p, int n) {
        return this.addAtBottomIfNotExists(p, n) != null;
    }

    public synchronized P addAtBottomIfNotExists(P p, int n) {
        n = this.validatePriority(n);
        QueueEntry<Object> queueEntry = this.entries.get(p);
        if (queueEntry != null) {
            queueEntry.remove();
            if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
            }
            queueEntry.priority = n;
            queueEntry.insertBefore(this.queues[n]);
            this.itemPresenceMask |= 1 << 31 - n;
            this.notifyAll();
            return (P)queueEntry.payload;
        }
        queueEntry = new QueueEntry(p, p, n);
        this.entries.put(p, queueEntry);
        queueEntry.insertBefore(this.queues[n]);
        this.itemPresenceMask |= 1 << 31 - n;
        this.notifyAll();
        return null;
    }

    public boolean addAtBottomUnsynced(P p, int n) {
        return this.addAtBottomIfNotExistsUnsynced(p, n) != null;
    }

    public P addAtBottomIfNotExistsUnsynced(P p, int n) {
        n = this.validatePriority(n);
        QueueEntry<Object> queueEntry = this.entries.get(p);
        if (queueEntry != null) {
            queueEntry.remove();
            if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
            }
            queueEntry.priority = n;
            queueEntry.insertBefore(this.queues[n]);
            this.itemPresenceMask |= 1 << 31 - n;
            return (P)queueEntry.payload;
        }
        queueEntry = new QueueEntry(p, p, n);
        this.entries.put(p, queueEntry);
        queueEntry.insertBefore(this.queues[n]);
        this.itemPresenceMask |= 1 << 31 - n;
        return null;
    }

    protected synchronized QueueEntry<P> getFirstEntry(int n) {
        int n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask);
        do {
            if (n2 < this.consumptionThreshold && n2 <= n) continue;
            try {
                this.wait();
                n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask);
            }
            catch (InterruptedException interruptedException) {}
        } while (n2 >= this.consumptionThreshold || n2 > n);
        return this.queues[n2].next;
    }

    public boolean hasClaimableItemsUnsynced(int n) {
        return Integer.numberOfLeadingZeros(this.itemPresenceMask) <= n;
    }

    public synchronized P peekBlocking(int n) {
        return (P)this.getFirstEntry((int)n).payload;
    }

    public P peekUnsynced(int n) {
        int n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask);
        if (n2 >= this.consumptionThreshold || n2 > n) {
            return null;
        }
        return (P)this.queues[n2].next.payload;
    }

    public synchronized P consume(int n) {
        QueueEntry<P> queueEntry = this.getFirstEntry(n);
        queueEntry.remove();
        this.entries.remove(queueEntry.uid);
        if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
            this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
        }
        return (P)queueEntry.payload;
    }

    public int remove(P p) {
        QueueEntry<P> queueEntry = this.entries.remove(p);
        if (queueEntry != null) {
            queueEntry.remove();
            if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
            }
            return queueEntry.priority;
        }
        return -1;
    }

    public P removeAndGetUnsynced(P p) {
        QueueEntry<P> queueEntry = this.entries.remove(p);
        if (queueEntry != null) {
            queueEntry.remove();
            if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
            }
            return (P)queueEntry.payload;
        }
        return null;
    }

    public P find(Object object) {
        QueueEntry<P> queueEntry = this.entries.get(object);
        return queueEntry != null ? (P)queueEntry.payload : null;
    }

    public synchronized void changePriority(P p, int n, boolean bl) {
        n = this.validatePriority(n);
        QueueEntry<P> queueEntry = this.entries.get(p);
        if (queueEntry != null && queueEntry.priority != n) {
            this.changePriority(queueEntry, n, bl);
            this.notify();
        }
    }

    public synchronized void raisePriority(P p, int n, boolean bl) {
        n = this.validatePriority(n);
        QueueEntry<P> queueEntry = this.entries.get(p);
        if (queueEntry != null && queueEntry.priority >= n) {
            this.changePriority(queueEntry, n, bl);
            this.notify();
        }
    }

    private void changePriority(QueueEntry<P> queueEntry, int n, boolean bl) {
        queueEntry.remove();
        if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
            this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
        }
        queueEntry.priority = n;
        if (bl) {
            queueEntry.insertBefore(this.queues[n]);
            this.itemPresenceMask |= 1 << 31 - n;
        } else {
            queueEntry.insertAfter(this.queues[n]);
            this.itemPresenceMask |= 1 << 31 - n;
        }
    }

    public synchronized void setConsumptionThreshold(int n) {
        boolean bl = this.consumptionThreshold < n;
        this.consumptionThreshold = n;
        if (bl) {
            this.notifyAll();
        }
    }

    public void replace(P p, P p2) {
        QueueEntry<P> queueEntry = this.entries.remove(p);
        queueEntry.payload = p2;
        this.entries.put(p2, queueEntry);
    }

    public synchronized void visit(IRequestQueueVisitor<P> iRequestQueueVisitor, int n) {
        int n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask);
        int n3 = Math.min(Math.min(this.consumptionThreshold + 1, n), this.queues.length);
        int n4 = n2;
        while (n4 < n3) {
            QueueEntry queueEntry = this.queues[n4].next;
            while (queueEntry != this.queues[n4]) {
                QueueEntry queueEntry2 = queueEntry.next;
                if (!iRequestQueueVisitor.wantsMore()) {
                    return;
                }
                if (iRequestQueueVisitor.offerRequest(queueEntry.payload)) {
                    queueEntry.remove();
                    this.entries.remove(queueEntry.uid);
                    if (this.queues[queueEntry.priority].next == this.queues[queueEntry.priority]) {
                        this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
                    }
                }
                queueEntry = queueEntry2;
            }
            ++n4;
        }
    }

    public synchronized boolean isEmpty() {
        return this.itemPresenceMask == 0;
    }

    public Iterator<P> iterator(int n) {
        return new QueueIterator(n);
    }

    public synchronized void lock() {
        if (this.consumptionThreshold >= 0) {
            this.cthBackup = this.consumptionThreshold;
        }
        this.consumptionThreshold = -1;
    }

    public synchronized void unlock() {
        if (this.cthBackup >= 0) {
            this.consumptionThreshold = this.cthBackup;
        }
        this.notifyAll();
    }

    public int size() {
        return this.entries.size();
    }

    public String toString() {
        String string = "QueueSize = " + this.size() + "\n";
        Iterator<P> iterator = this.iterator(this.queues.length);
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            string = String.valueOf(string) + string2 + "\n";
        }
        return string;
    }

    protected class QueueEntry<S> {
        public final Object uid;
        public S payload;
        public int priority;
        public QueueEntry<S> next;
        private QueueEntry<S> previous;

        private QueueEntry(S s, S s2, int n) {
            this.uid = s;
            this.payload = s2;
            this.priority = n;
        }

        private QueueEntry(int n) {
            this.uid = "HEAD";
            this.priority = n;
            this.payload = null;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
        }

        public void insertAfter(QueueEntry<S> queueEntry) {
            this.next = queueEntry.next;
            this.previous = queueEntry;
            this.previous.next = this;
            this.next.previous = this;
        }

        public void insertBefore(QueueEntry<S> queueEntry) {
            this.next = queueEntry;
            this.previous = queueEntry.previous;
            this.previous.next = this;
            this.next.previous = this;
        }
    }

    private class QueueIterator
    implements Iterator<P> {
        private int binIndex;
        private QueueEntry<P> current;
        private QueueEntry<P> future;
        private QueueEntry<P> previous;
        private final int limit;

        public QueueIterator(int n) {
            if (n >= PriorityQueue.this.queues.length) {
                n = PriorityQueue.this.queues.length - 1;
            }
            this.limit = n;
            this.binIndex = Integer.numberOfLeadingZeros(PriorityQueue.this.itemPresenceMask);
            this.advance();
            this.current = this.future;
            this.advance();
        }

        private void advance() {
            while (this.binIndex <= this.limit) {
                if (this.future == null) {
                    if (PriorityQueue.this.queues[this.binIndex].next == PriorityQueue.this.queues[this.binIndex]) continue;
                    this.future = PriorityQueue.this.queues[this.binIndex].next;
                    return;
                }
                if (this.future.next != PriorityQueue.this.queues[this.binIndex]) {
                    this.future = this.future.next;
                    return;
                }
                ++this.binIndex;
                if (this.binIndex >= PriorityQueue.this.queues.length) continue;
                this.future = PriorityQueue.this.queues[this.binIndex].next;
                if (this.future == this.future.next) continue;
                return;
            }
            this.future = null;
        }

        @Override
        public boolean hasNext() {
            return this.future != null;
        }

        @Override
        public P next() {
            this.previous = this.current;
            this.current = this.future;
            this.advance();
            return this.previous.payload;
        }

        @Override
        public void remove() {
            PriorityQueue.this.removeAndGetUnsynced(this.previous.payload);
        }
    }
}

