/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class StringTools {
    public static final String DEFAULT_PARAMETER_MAP_SEPARATOR = " ";
    public static final char KEY_VALUE_SEPARATOR = '=';
    private static final String GIGABYTE_SUFFIX = "GB";
    private static final String MEGABYTE_SUFFIX = "MB";
    private static final String KILOBYTE_SUFFIX = "KB";
    private static final long TWO_TO_TENTH_POWER = 1024L;
    private static final String STRING_INCREMENT_BASE_SUFFIX = " (2)";
    private static final int COMPOSED_PARAMETER_STRING_ESTIMATED_LENGTH = 300;
    private static final int CLEANED_STRING_ESTIMATED_LENGTH = 100;
    private static final int COMPOSED_LIST_STRING_ESTIMATED_LENGTH = 200;
    private static final ALogger logger = ALogger.getLogger(StringTools.class);
    private static final java.util.regex.Pattern nonWhiteSpaceCharacter = java.util.regex.Pattern.compile("\\S+");

    public static long parseMemoryAmount(String string) {
        try {
            String string2 = string.trim().toUpperCase();
            if (string2.endsWith(GIGABYTE_SUFFIX)) {
                String string3 = string2.substring(0, string2.length() - GIGABYTE_SUFFIX.length()).trim();
                return Long.parseLong(string3) * 1024L * 1024L * 1024L;
            }
            if (string2.endsWith(MEGABYTE_SUFFIX)) {
                String string4 = string2.substring(0, string2.length() - MEGABYTE_SUFFIX.length()).trim();
                return Long.parseLong(string4) * 1024L * 1024L;
            }
            if (string2.endsWith(KILOBYTE_SUFFIX)) {
                String string5 = string2.substring(0, string2.length() - KILOBYTE_SUFFIX.length()).trim();
                return Long.parseLong(string5) * 1024L;
            }
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            throw new NumberFormatException("error while parsing " + string);
        }
    }

    public static Map<String, String> parseParameterMap(String string) {
        return StringTools.parseParameterMap(string, DEFAULT_PARAMETER_MAP_SEPARATOR);
    }

    public static Map<String, String> parseParameterMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || string2 == null) {
            return hashMap;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4;
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf(61);
            if (n == -1) {
                string4 = string5;
                string3 = null;
            } else {
                string4 = string5.substring(0, n).trim();
                string3 = string5.substring(n + 1).trim();
            }
            if (string4.length() <= 0) continue;
            hashMap.put(string4, string3);
        }
        return hashMap;
    }

    public static String composeParameterString(Parameters parameters, String string) {
        StringBuilder stringBuilder = new StringBuilder(300);
        for (Map.Entry<String, String> entry : parameters) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (string3 == null || !string3.contains(string)) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
                if (string3 == null) continue;
                stringBuilder.append('=');
                stringBuilder.append(string3);
                continue;
            }
            logger.error("Illegal parameter value '{}'", (Object)string3);
        }
        return stringBuilder.toString();
    }

    public static String composeParameterString(Parameters parameters) {
        return StringTools.composeParameterString(parameters, DEFAULT_PARAMETER_MAP_SEPARATOR);
    }

    public static String[] appendStringValue(String[] stringArray, String string) {
        if (stringArray == null) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static boolean containsStringValue(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String deleteChars(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuilder stringBuilder = new StringBuilder(100);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(stringTokenizer.nextToken());
        }
        return stringBuilder.toString();
    }

    public static String incrementString(String string, Set<String> set) {
        if (string == null || set == null || set.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ')' && set.contains(string)) {
            stringBuilder.append(STRING_INCREMENT_BASE_SUFFIX);
        }
        while (set.contains(stringBuilder.toString())) {
            if (stringBuilder.charAt(stringBuilder.length() - 1) == ')') {
                int n = stringBuilder.lastIndexOf("(");
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(stringBuilder.substring(n + 1, stringBuilder.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {}
                if (n2 != -1) {
                    stringBuilder.delete(n + 1, stringBuilder.length());
                    stringBuilder.append(n2 + 1);
                    stringBuilder.append(')');
                    continue;
                }
                stringBuilder.append(STRING_INCREMENT_BASE_SUFFIX);
                continue;
            }
            stringBuilder.append(STRING_INCREMENT_BASE_SUFFIX);
        }
        return stringBuilder.toString();
    }

    public static List<String> split(String string, String string2) {
        return StringTools.split(string, string2, false);
    }

    public static List<String> split(String string, String string2, boolean bl) {
        String string3;
        if (string2 == null) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = string.indexOf(string2, n2))) {
            string3 = string.substring(n, n2);
            if (string3.length() > 0 || bl) {
                arrayList.add(string3);
            }
            n = n2 += string2.length();
        }
        if (n != string.length()) {
            string3 = string.substring(n, string.length());
            if (string3.length() > 0 || bl) {
                arrayList.add(string3);
            }
        } else if (bl) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static boolean containsNoneWhiteSpaceCharacter(String string) {
        Matcher matcher = nonWhiteSpaceCharacter.matcher(string);
        return matcher.find();
    }

    public static boolean containsNoneWhiteSpaceCharacter(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (StringTools.containsNoneWhiteSpaceCharacter(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] splitToLines(String string) {
        return Pattern.NEWLINE.split(string);
    }

    public static int getWhiteSpaceSequenceStartPosition(String string, int n) {
        int n2 = n - 1;
        if (string != null) {
            while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
                --n2;
            }
        } else {
            logger.warn("String which is analyzed for whitespace sequence is null");
            return -1;
        }
        return n2 + 1;
    }

    @Deprecated
    public static String composeList(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = 0;
        while (n < list.size()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(list.get(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static class Parameters
    implements Iterable<Map.Entry<String, String>> {
        private static final int DEFAULT_INITIAL_CAPACITY = 8;
        private final LinkedHashMap<String, String> parametersOrderedMap;

        public Parameters() {
            this.parametersOrderedMap = new LinkedHashMap(8);
        }

        public Parameters(int n) {
            this.parametersOrderedMap = new LinkedHashMap(n);
        }

        public Parameters add(String string, String string2) {
            Objects.requireNonNull(string);
            this.parametersOrderedMap.put(string, string2);
            return this;
        }

        public Parameters add(String string, Object object) {
            String string2 = object != null ? object.toString() : null;
            this.add(string, string2);
            return this;
        }

        public String toString() {
            return StringTools.composeParameterString(this);
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.parametersOrderedMap.entrySet().iterator();
        }
    }
}

