/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.tools.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.log4j.Logger;

public class TempDirectoryProvider {
    private static final Logger log;
    private static final String JAVA_TEMP_IO = "java.io.tmpdir";
    public static final String AGILITY_CACHE_DIR_INFIX;
    private static final String LOCKFILE_NAME = "lock";
    private static Path temporaryDirectory;

    static {
        FileLock fileLock;
        FileOutputStream fileOutputStream;
        log = Logger.getLogger(TempDirectoryProvider.class);
        AGILITY_CACHE_DIR_INFIX = "AgilityCache" + File.separator + TempDirectoryProvider.getDesktopType();
        Path path = Paths.get(System.getProperty(JAVA_TEMP_IO), "AgilityTemp");
        try {
            path = Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        TempDirectoryProvider.cleanupOldTemporaryDirectories(path);
        try {
            temporaryDirectory = Files.createTempDirectory(path, null, new FileAttribute[0]);
            File file = temporaryDirectory.resolve(LOCKFILE_NAME).toFile();
            fileOutputStream = new FileOutputStream(file);
            fileLock = fileOutputStream.getChannel().lock();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    fileLock.release();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                FileUtil.remove(temporaryDirectory.toFile());
            }
        }));
    }

    private static void cleanupOldTemporaryDirectories(Path path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    File file;
                    if (!Files.isDirectory(path2, new LinkOption[0]) || (file = path2.toFile()).lastModified() > System.currentTimeMillis() - 60000L) continue;
                    boolean bl = false;
                    File file2 = path2.resolve(LOCKFILE_NAME).toFile();
                    if (file2.exists()) {
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                            FileLock fileLock = fileOutputStream.getChannel().tryLock();
                            if (fileLock == null) {
                                bl = true;
                            } else {
                                fileLock.release();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (bl) continue;
                    FileUtil.remove(file);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error deleting old temp directories", (Throwable)iOException);
        }
    }

    public static Path createTempDirectory(String string) throws IOException {
        return Files.createTempDirectory(temporaryDirectory, string, new FileAttribute[0]);
    }

    public static Path getCacheDirectory(String string) {
        Path path = Paths.get(System.getProperty(JAVA_TEMP_IO), AGILITY_CACHE_DIR_INFIX);
        Path path2 = path.resolve(string).normalize();
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return path2;
    }

    public static String getDesktopType() {
        return System.getProperty("form", "diagnostic.desktop");
    }

    public static File createTemporaryFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, temporaryDirectory.toFile());
    }
}

