/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.logging.filter;

import org.apache.log4j.Level;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class ExceptionFilter
extends Filter {
    private static long latestMatchTimestamp;
    private static Level latestMatchLevel;
    private static String latestMatchLoggerName;
    private long tolerance = 200L;
    private String[] matchingPatterns = new String[]{".*Exception.*", ".*Error.*", ".*Failure.*", ".*TrafoStackNotReady.*"};

    protected boolean isNewException(LoggingEvent loggingEvent) {
        if (loggingEvent.getThrowableInformation() != null) {
            return true;
        }
        String string = loggingEvent.getRenderedMessage();
        if (string != null) {
            int n = 0;
            while (n < this.matchingPatterns.length) {
                if (string.matches(this.matchingPatterns[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int decide(LoggingEvent loggingEvent) {
        if (loggingEvent.getThrowableInformation() != null) {
            return 1;
        }
        if (this.isNewException(loggingEvent)) {
            latestMatchTimestamp = loggingEvent.timeStamp;
            latestMatchLevel = loggingEvent.getLevel();
            latestMatchLoggerName = loggingEvent.getLoggerName();
            return 1;
        }
        if (loggingEvent.timeStamp - latestMatchTimestamp < this.tolerance && loggingEvent.getLevel().equals((Object)latestMatchLevel) && loggingEvent.getLoggerName().equals(latestMatchLoggerName)) {
            latestMatchTimestamp = loggingEvent.timeStamp;
            return 1;
        }
        return -1;
    }

    public void setTolerance(long l) {
        this.tolerance = l;
    }

    public long getTolerance() {
        return this.tolerance;
    }

    public void setMatchingPatterns(String string) {
        this.matchingPatterns = string.split(",");
    }

    public String[] getMatchingPatterns() {
        return this.matchingPatterns;
    }
}

