/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.PopulateLog;
import com.agfa.pacs.tools.CitrixUtils;
import java.io.File;
import java.util.Enumeration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

class LogHandler {
    private static LoggingConfigListener configListener = new LoggingConfigListener();
    private static boolean logExists = LogHandler.logExists();
    private static final String USE_LOG4J_RESOURCE = "log4j.useResource";
    public static final String REDIRECT_STD_OUT_ERR = "log4j.redirectStdOutErr";
    private static boolean useLog4jResource = "true".equalsIgnoreCase(System.getProperty("log4j.useResource", "false"));
    private static boolean redirectStdOutErr = "true".equalsIgnoreCase(System.getProperty("log4j.redirectStdOutErr", "false"));

    LogHandler() {
    }

    public static boolean redirectStdOut() {
        return useLog4jResource && redirectStdOutErr;
    }

    static void startLogging() {
        File file = new File("AgfaPegasusWrapper.log");
        if (file.exists()) {
            file.delete();
        }
        LogHandler.configureLog4j(true);
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener("logging", (IConfigurationChangeListener)configListener);
    }

    static void applyChangesToFileAppenders() {
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof RollingFileAppender)) continue;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)e;
            if (CitrixUtils.isRunningInCitrixEnviroment()) {
                rollingFileAppender.setFile(String.valueOf(CitrixUtils.getUniqueSessionName()) + "_" + rollingFileAppender.getFile());
                rollingFileAppender.activateOptions();
            }
            if (!logExists) continue;
            rollingFileAppender.rollOver();
        }
    }

    private static void configureLog4j(boolean bl) {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("logging");
        String string = iConfigurationProvider.getString("level");
        try {
            Logger logger = Logger.getRootLogger();
            Level level = Level.toLevel((String)string);
            Level level2 = logger.getLevel();
            if (!level.equals((Object)level2)) {
                logger.setLevel(level);
                Logger.getLogger((String)"LogConfig").log((Priority)level, (Object)("Log level set to:" + level.toString()));
            }
        }
        catch (Exception exception) {
            ALogger.getLogger((String)"LogConfig").error("Could not update log level");
        }
    }

    private static boolean logExists() {
        if (!LogHandler.redirectStdOut()) {
            String string = System.getProperty("instanceLogFolder");
            if (string != null) {
                PopulateLog.LOG_FILE_NAME = String.valueOf(string) + "/" + PopulateLog.LOG_FILE_NAME;
            }
            File file = new File(PopulateLog.LOG_FILE_NAME);
            return file.exists();
        }
        return false;
    }

    private static class LoggingConfigListener
    implements IConfigurationChangeListener {
        private LoggingConfigListener() {
        }

        public void configurationChanged(String string) {
            LogHandler.configureLog4j(false);
        }
    }
}

