/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.core.ApplicationType;
import com.agfa.pacs.core.app.ApplicationInformationFactory;
import com.agfa.pacs.jna.wintools.WindowsTools;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IAutoLoginCredsProvider;
import com.agfa.pacs.login.ILogin;
import com.agfa.pacs.login.ILoginData;
import com.agfa.pacs.login.ILoginManager;
import com.agfa.pacs.login.ISession;
import com.agfa.pacs.login.LogHandler;
import com.agfa.pacs.login.LoginFactory;
import com.agfa.pacs.login.LoginSessionFactory;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.login.certificate.ImpaxEECertificate;
import com.agfa.pacs.login.impl.ApplicationBlocker;
import com.agfa.pacs.login.impl.AutoLoginFactory;
import com.agfa.pacs.login.launcher.ILauncher;
import com.agfa.pacs.login.launcher.LaunchException;
import com.agfa.pacs.login.launcher.LauncherFactory;
import com.agfa.pacs.login.serviceTools.IServiceTool;
import com.agfa.pacs.login.serviceTools.ServiceToolFactory;
import com.agfa.pacs.login.ui.ILoginUI;
import com.agfa.pacs.login.ui.LoginUIFactory;
import com.agfa.pacs.login.ui.credentials.ILoginCredentials;
import com.agfa.pacs.login.ui.credentials.LoginCredentialsFactory;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.agfa.pacs.tools.ComputerName;
import com.agfa.pacs.tools.Pattern;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class LoginManager
implements IApplication,
ILoginManager {
    private ALogger log = null;
    private static String impersonationRole = null;
    private static final String IMPERSONIFICATION_FILE = ".imper";
    private static LoginManager jumpstartInstance = null;
    private static IApplicationContext appContext = null;
    private static long startingTime;
    private boolean wasImpersonated = false;
    private ApplicationBlocker blocker = null;
    private Integer returnCode = IApplication.EXIT_OK;
    private ILoginUI ui = null;

    public LoginManager() {
        this.blocker = new ApplicationBlocker();
    }

    @Override
    public void exit() {
        this.terminate();
    }

    private void terminate() {
        this.blocker.shutdown();
    }

    private ILogin getLogin() {
        List<ILogin> list = LoginFactory.getInstance().getLoginFactories();
        if (list == null || list.isEmpty()) {
            this.getLog().error("FATAL: No login found");
            return null;
        }
        return list.get(0);
    }

    @Override
    public synchronized void startApplication() {
        startingTime = System.currentTimeMillis();
        String string = System.getProperty("launcher");
        new ApplicationLauncher(string).launchApplications();
        jumpstartInstance = null;
    }

    private void startLogging() {
        Object object;
        ILoginData iLoginData = URLProviderFactory.getProvider().getLoginInformation();
        String[] stringArray = iLoginData.getRoles();
        if (iLoginData.getImpersonificationRole() == null) {
            if (stringArray != null && stringArray.length > 1) {
                object = RoleManagerFactory.showRoleChooserDialog((List)RoleManagerFactory.convertRoles((String[])stringArray), (boolean)false);
                if (object == null) {
                    this.getLog().warn("Choosing not to login");
                    System.exit(1);
                } else {
                    iLoginData.chooseEffectiveRole(object.getFullPath());
                }
            } else if (stringArray != null && stringArray.length == 0) {
                this.getLog().error("No role specified");
            }
        }
        LogHandler.startLogging();
        this.getLog().info("My role is:" + URLProviderFactory.getProvider().getLoginInformation().getRole());
        object = DateFormat.getDateInstance();
        this.getLog().info("Current Date: " + ((DateFormat)object).format(new Date()) + ", Computer name: " + ComputerName.getComputerId() + "[" + ComputerName.getComputerIP() + "]");
        Runtime runtime = Runtime.getRuntime();
        this.getLog().info("Running java version: " + System.getProperty("java.version") + " in " + System.getProperty("java.home"));
        this.getLog().info("OS version: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
        this.getLog().info("JVM total memory: " + runtime.totalMemory() + ", max. memory: " + runtime.maxMemory() + ", free memory: " + runtime.freeMemory() + " [in bytes]");
        this.getLog().info("Running on Computer with " + runtime.availableProcessors() + " cores");
    }

    private void startFromSession(ILogin iLogin, String string, String string2) {
        Object object;
        if (System.getProperty("server.host") == null && System.getProperty("login.servers") != null) {
            object = System.getProperty("login.servers");
            object = ((String)object).trim();
            object = ((String)object).replace(")", "");
            String[] stringArray = ((String)object).split(",|\\(");
            System.setProperty("server.host", stringArray[0]);
        }
        object = new HashMap<String, String>();
        ((HashMap)object).put("session", string);
        ((HashMap)object).put("role", impersonationRole);
        ((HashMap)object).put("userid", string2);
        if (iLogin.verifyLogin((Map)object) == ILogin.LoginResult.Allowed) {
            iLogin.createLoginConfiguration((Map)object);
            this.startApplication();
            return;
        }
    }

    private boolean checkAutoLogin(ILogin iLogin) {
        boolean bl = LoginManager.isInOfflineModus();
        List<IAutoLoginCredsProvider> list = AutoLoginFactory.getInstance().getAutoCredentialsProviders();
        for (IAutoLoginCredsProvider iAutoLoginCredsProvider : list) {
            ILogin.LoginResult loginResult;
            String string = iAutoLoginCredsProvider.provideUsername();
            String string2 = iAutoLoginCredsProvider.providePassword();
            if (string == null || string2 == null || string.length() <= 0 || string2.length() <= 0) continue;
            if (!LoginManager.isCaseSensitiveLogin()) {
                string = string.toUpperCase(Locale.getDefault());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("userid", string);
            hashMap.put("password", string2);
            if (bl) {
                hashMap.put("offline", Boolean.TRUE.toString());
            }
            if ((loginResult = iLogin.verifyLogin(hashMap)) != ILogin.LoginResult.Allowed) continue;
            iLogin.createLoginConfiguration(hashMap);
            this.startApplication();
            return true;
        }
        return false;
    }

    public static boolean isCaseSensitiveLogin() {
        boolean bl = false;
        String string = System.getProperty("login.case");
        if (string != null) {
            try {
                bl = Boolean.parseBoolean(string);
            }
            catch (RuntimeException runtimeException) {}
        }
        return bl;
    }

    public static void setLoginWithDifferentCredentials(String string, String string2) {
        File file = new File(IMPERSONIFICATION_FILE);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fileWriter = new FileWriter(file);){
                String string3 = System.getProperty("line.separator");
                fileWriter.write(string3);
                fileWriter.write(String.valueOf(string) + string3);
                fileWriter.write(String.valueOf(string2) + string3);
                fileWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            ALogger.getLogger(LoginManager.class).error("Could not store relogin data", (Throwable)iOException);
        }
    }

    private boolean showLoginDialog(String string, String string2, IApplicationContext iApplicationContext) throws Exception {
        ILogin iLogin = this.getLogin();
        if (iLogin == null) {
            throw new Error("No login provider included");
        }
        if (this.ui == null && iLogin.requireInput()) {
            try {
                this.ui = LoginUIFactory.getInstance().getLoginUIs().get(0);
            }
            catch (Exception exception) {
                this.getLog().error("No com.agfa.pacs.login.LoginUI implementation found!", (Throwable)exception);
            }
        }
        if (string != null) {
            iApplicationContext.applicationRunning();
            this.startFromSession(iLogin, string, string2);
            return true;
        }
        if (!iLogin.requireInput()) {
            if (iLogin.verifyLogin(null) != ILogin.LoginResult.Allowed) {
                iLogin.showMessage("Auto-login not successfull", "Could not log in", true);
                iLogin.showMessage("Login failed", "user:'" + System.getProperty("login.user"), false);
            } else {
                iLogin.createLoginConfiguration(null);
                if (iApplicationContext != null) {
                    iApplicationContext.applicationRunning();
                }
                this.startApplication();
                return true;
            }
        }
        if (!this.checkAutoLogin(iLogin)) {
            if (this.ui == null) {
                this.ui = LoginUIFactory.getInstance().getLoginUIs().get(0);
            }
            this.ui.showDialog(this, this.getLaunchers(), this.getCredentialsProviders());
            return false;
        }
        return true;
    }

    private List<ILauncher> getLaunchers() {
        return LauncherFactory.getInstance().getLauncher();
    }

    private List<ILoginCredentials> getCredentialsProviders() {
        return LoginCredentialsFactory.getInstance().getLoginCredititals();
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        String string;
        ILogin iLogin;
        ISession iSession;
        Object object;
        Object object2;
        Object var4_4;
        System.setProperty("sun.java2d.ddscale", "true");
        System.setProperty("sun.java2d.accthreshold", "0");
        System.setProperty("sun.java2d.translaccel", "true");
        System.setProperty("sun.awt.noerasebackground", "true");
        ComputerName.getComputerId();
        String string2 = null;
        String string3 = null;
        Object v0 = var4_4 = iApplicationContext != null ? iApplicationContext.getArguments().get("application.args") : null;
        if (var4_4 instanceof String[]) {
            object2 = var4_4;
            int n = ((String[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                iSession = Pattern.EQUAL.split((CharSequence)object);
                if (((String[])iSession).length == 2) {
                    System.setProperty(iSession[0], iSession[1]);
                }
                ++n2;
            }
        }
        if (((File)(object = new File(IMPERSONIFICATION_FILE))).exists()) {
            if ((System.currentTimeMillis() - ((File)object).lastModified()) / 60000L > 3L) {
                ((File)object).delete();
                this.getLog().warn("Too old imper file");
            } else {
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader((File)object));
                impersonationRole = lineNumberReader.readLine();
                string3 = lineNumberReader.readLine();
                string2 = lineNumberReader.readLine();
                lineNumberReader.close();
                ((File)object).delete();
                if (impersonationRole != null && impersonationRole.trim().isEmpty()) {
                    impersonationRole = null;
                    System.setProperty("login.user", string3);
                    System.setProperty("login.password", string2);
                    string2 = null;
                } else {
                    this.wasImpersonated = true;
                    this.getLog().warn("Impersonated login as:" + impersonationRole);
                }
            }
        }
        if (ApplicationInformationFactory.getInstance().getApplicationInformation().getType().equals((Object)ApplicationType.ImpaxEE)) {
            KeyStore keyStore = ImpaxEECertificate.getInstance().loadImpaxEETrustStore();
            SSLContext sSLContext = this.createSSLContext(keyStore);
            SSLContext.setDefault(sSLContext);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new TrustfulHostnameVerifier());
        }
        if ((iLogin = this.getLogin()) != null) {
            iLogin.requireInput();
        }
        if ((string = System.getProperty("jumpstart")) != null && string.equalsIgnoreCase("true")) {
            this.startJumpstart(iApplicationContext);
        }
        this.showLoginDialog(string2, string3, iApplicationContext);
        if (ApplicationInformationFactory.getInstance().getApplicationInformation().getType().equals((Object)ApplicationType.ImpaxEE)) {
            this.checkEnableComposition();
        }
        this.blocker.waitForTermination();
        if (impersonationRole != null && !this.wasImpersonated) {
            this.returnCode = IApplication.EXIT_RESTART;
            object = new File(IMPERSONIFICATION_FILE);
            object2 = new PrintWriter((File)object);
            ((PrintWriter)object2).println(impersonationRole);
            ((PrintWriter)object2).println(URLProviderFactory.getProvider().getLoginInformation().getUserID());
            iSession = LoginSessionFactory.getSession();
            if (iSession != null) {
                ((PrintWriter)object2).println(iSession.toString());
            }
            ((PrintWriter)object2).close();
        }
        if (!this.getLogin().restartAllowed()) {
            this.returnCode = IApplication.EXIT_OK;
        }
        if (this.returnCode.equals(IApplication.EXIT_OK)) {
            System.exit(0);
        }
        return this.returnCode;
    }

    public void stop() {
    }

    public static boolean isInOfflineModus() {
        File file = new File(Platform.getConfigurationLocation().getURL().getFile(), "pacs");
        return new File(file, ".offline").exists();
    }

    public static long getStartingTime() {
        return startingTime;
    }

    private synchronized void startJumpstart(IApplicationContext iApplicationContext) throws Exception {
        this.getLog().warn("Starting in jumpstart modus");
        jumpstartInstance = this;
        appContext = iApplicationContext;
        List<ILauncher> list = LauncherFactory.getInstance().getLauncher();
        for (ILauncher iLauncher : list) {
            if (iLauncher.getType() != ILauncher.LauncherType.Jumpstart) continue;
            new DaemonLauncher(iLauncher).start();
        }
    }

    public static synchronized void finishJumpstart(boolean bl, PropertyChangeListener propertyChangeListener) {
        if (jumpstartInstance == null) {
            return;
        }
        if (LoginManager.jumpstartInstance.ui != null) {
            LoginManager.jumpstartInstance.ui.hideDialog();
        }
        if (bl) {
            try {
                boolean bl2 = jumpstartInstance.showLoginDialog(null, null, appContext);
                if (propertyChangeListener != null) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(propertyChangeListener, "login", null, bl2);
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
                if (bl2) {
                    jumpstartInstance = null;
                    appContext = null;
                }
            }
            catch (Exception exception) {
                jumpstartInstance.getLog().error("Login error", (Throwable)exception);
            }
        } else {
            jumpstartInstance.exit();
        }
    }

    public static void setImpersonficationRole(String string) {
        ALogger.getLogger(LoginManager.class).warn("Impersonification set to role:" + string);
        impersonationRole = string;
    }

    @Override
    public ILogin.LoginResult checkLogin(Map<String, String> map) {
        ILogin.LoginResult loginResult = this.getLogin().verifyLogin(map);
        if (!loginResult.equals((Object)ILogin.LoginResult.Allowed)) {
            return loginResult;
        }
        this.getLogin().createLoginConfiguration(map);
        return loginResult;
    }

    private ALogger getLog() {
        if (this.log == null) {
            this.log = ALogger.getLogger(LoginManager.class);
        }
        return this.log;
    }

    private SSLContext createSSLContext(KeyStore keyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sSLContext;
    }

    private void checkEnableComposition() {
        String string = System.getProperty("enableComposition");
        if (string != null) {
            boolean bl = Boolean.parseBoolean(string);
            int n = WindowsTools.getInstance().enableComposition(bl);
            if (n == 0) {
                this.getLog().info("Call to DwmEnableComposition with value '" + Boolean.toString(bl) + "' was successful");
            } else if (n == -1) {
                this.getLog().warn("DwmEnableComposition is not supported on this OS.");
            } else {
                this.getLog().error("Call to DwmEnableComposition failed with HRESULT=" + n);
            }
        }
    }

    private class ApplicationLauncher {
        private final List<Thread> applicationThreads = new Vector<Thread>();
        private final Object monitor = new Object();
        private String prefLauncher = null;

        public ApplicationLauncher(String string) {
            this.prefLauncher = string;
        }

        public void launchApplications() {
            ArrayList<ILauncher> arrayList = new ArrayList<ILauncher>();
            for (ILauncher object : LauncherFactory.getInstance().getLauncher()) {
                if (this.shouldLaunch(object)) {
                    arrayList.add(object);
                    continue;
                }
                if (object.getType() != ILauncher.LauncherType.Prestart) continue;
                try {
                    object.launch();
                }
                catch (Exception exception) {
                    LoginManager.this.getLog().error("Error launching tool:", (Throwable)exception);
                }
            }
            LoginManager.this.startLogging();
            if (this.prefLauncher == null) {
                for (IServiceTool iServiceTool : ServiceToolFactory.getInstance().getServiceTools()) {
                    iServiceTool.start();
                }
            }
            Collections.sort(arrayList, new NameSorter());
            for (ILauncher iLauncher : arrayList) {
                this.applicationThreads.add(new LaunchThread(iLauncher));
            }
            if (this.applicationThreads.isEmpty()) {
                LoginManager.this.getLog().error("No launcher found");
                return;
            }
            for (Thread thread : this.applicationThreads) {
                thread.start();
            }
        }

        private boolean shouldLaunch(ILauncher iLauncher) {
            if (this.prefLauncher != null) {
                if (this.prefLauncher.equalsIgnoreCase(iLauncher.getId())) {
                    return true;
                }
                LoginManager.this.getLog().warn("Launching " + iLauncher.getId() + " discarded!");
                return false;
            }
            return iLauncher.getType() == ILauncher.LauncherType.Normal;
        }

        private class LaunchThread
        extends Thread {
            private ILauncher launcher = null;

            public LaunchThread(ILauncher iLauncher) {
                this.launcher = iLauncher;
                String string = iLauncher.getClass().getName();
                this.setName(string.substring(string.lastIndexOf(46) + 1));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                try {
                    object = this.launcher.launch();
                    if (!((Integer)object).equals(IApplication.EXIT_OK)) {
                        LoginManager.this.returnCode = (Integer)object;
                    }
                }
                catch (LaunchException launchException) {
                    LoginManager.this.getLog().error("Launcher exception", (Throwable)launchException);
                    return;
                }
                object = ApplicationLauncher.this.monitor;
                synchronized (object) {
                    ApplicationLauncher.this.applicationThreads.remove(this);
                    if (ApplicationLauncher.this.applicationThreads.isEmpty()) {
                        LoginManager.this.terminate();
                    }
                }
            }
        }
    }

    private class DaemonLauncher
    extends Thread {
        private final ILauncher launcher;

        public DaemonLauncher(ILauncher iLauncher) {
            this.launcher = iLauncher;
        }

        @Override
        public void run() {
            try {
                this.launcher.launch();
            }
            catch (LaunchException launchException) {
                LoginManager.this.getLog().error("Daemon Launch error", (Throwable)launchException);
            }
        }
    }

    private static class NameSorter
    implements Comparator<ILauncher> {
        private NameSorter() {
        }

        @Override
        public int compare(ILauncher iLauncher, ILauncher iLauncher2) {
            return iLauncher2.getDescription().compareTo(iLauncher.getDescription());
        }
    }

    private static class TrustfulHostnameVerifier
    implements HostnameVerifier {
        private TrustfulHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

