/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IHTTPPostDataProvider;
import com.agfa.pacs.login.ILoginData;
import com.agfa.pacs.login.IURLProvider;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class URLProvider
implements IURLProvider {
    private static final ALogger log = ALogger.getLogger(URLProvider.class);
    private String server;
    private String userName;
    private String loginURL;
    private String host;
    private volatile String userRole;
    private volatile ILoginData loginInfo;
    private Object monitor = new Object();
    private volatile boolean loggedIn = false;

    private void init() {
        boolean bl;
        this.host = System.getProperty("server.host");
        if (this.host == null) {
            this.host = "localhost";
            log.info("Default Server not specified.Using localhost");
        }
        this.server = (bl = Boolean.parseBoolean(System.getProperty("server.secure", Boolean.FALSE.toString()))) ? "https://" : "http://";
        String string = System.getProperty("server.port");
        if (string == null) {
            string = bl ? "8443" : "8080";
            log.info("Default Server port not specified. Using {}", (Object)string);
        }
        this.server = String.valueOf(this.server) + this.host + ":" + string + "/";
        this.userName = System.getProperty("user.name");
        this.loginURL = System.getProperty("login.url");
        if (this.loginURL == null) {
            log.info("No special login URL specified. Using the default server");
            this.loginURL = String.valueOf(this.server) + "Agility/denied.htm";
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLoginServiceUrl() {
        if (this.server == null || !this.loggedIn) {
            this.init();
        }
        return this.loginURL;
    }

    public String getServerUrl() {
        if (this.server == null || !this.loggedIn) {
            this.init();
        }
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserRole() {
        String string = this.userRole;
        if (string == null) {
            Object object = this.monitor;
            synchronized (object) {
                string = this.userRole;
                while (string == null) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    string = this.userRole;
                }
            }
        }
        return this.userRole;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILoginData getLoginInformation() {
        ILoginData iLoginData = this.loginInfo;
        if (iLoginData == null) {
            Object object = this.monitor;
            synchronized (object) {
                iLoginData = this.loginInfo;
                while (iLoginData == null) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    iLoginData = this.loginInfo;
                }
            }
        }
        return this.loginInfo;
    }

    public void setUserName(String string) {
        this.userName = string;
        if (this.host != null && !Character.isDigit(this.host.charAt(0))) {
            try {
                log.info("Login server is:" + this.host + " at:" + InetAddress.getByName(this.host).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
        } else if (this.host != null) {
            log.info("Login server is:" + this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoginData(ILoginData iLoginData) {
        Object object = this.monitor;
        synchronized (object) {
            this.loginInfo = iLoginData;
            this.userName = iLoginData.getUserID();
            this.userRole = iLoginData.getRole();
            this.loggedIn = true;
            this.monitor.notifyAll();
        }
    }

    @Nullable
    public InputStream performGETasStream(String string) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String performGETasString(String string) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public InputStream performPOSTasStream(String string, IHTTPPostDataProvider iHTTPPostDataProvider) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String performPOSTasString(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public InputStream performPOSTasStream(String string, String string2) {
        throw new UnsupportedOperationException();
    }
}

