/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login.certificate;

import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.dcm4che3.net.SSLManagerFactory;

public class ImpaxEECertificate {
    private static final ALogger log = ALogger.getLogger(ImpaxEECertificate.class);
    private KeyStore combinedKeystore;

    public static ImpaxEECertificate getInstance() {
        return LazyHolder.instance;
    }

    private ImpaxEECertificate() {
    }

    public synchronized KeyStore loadImpaxEETrustStore() {
        if (this.combinedKeystore == null) {
            KeyStore keyStore;
            KeyStore keyStore2;
            block19: {
                keyStore2 = null;
                try {
                    keyStore2 = KeyStore.getInstance("Windows-ROOT");
                    keyStore2.load(null, null);
                }
                catch (Exception exception) {
                    log.error("Failed to load trusted certificates from Windows", (Throwable)exception);
                }
                keyStore = null;
                InputStream inputStream = null;
                try {
                    try {
                        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        inputStream = this.getClass().getResourceAsStream("/IMPAXEE_trusted.jks");
                        keyStore.load(inputStream, "secret".toCharArray());
                    }
                    catch (Exception exception) {
                        log.error("Failed to load IMPAX EE trust store from resource", (Throwable)exception);
                        keyStore = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                log.error("Failed to close stream to IMPAX EE trusted certificate");
                            }
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            log.error("Failed to close stream to IMPAX EE trusted certificate");
                        }
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        log.error("Failed to close stream to IMPAX EE trusted certificate");
                    }
                }
            }
            try {
                this.combinedKeystore = this.mergeKeystores(keyStore, keyStore2);
            }
            catch (Exception exception) {
                log.error("Failed to merge IMPAX EE and system keystores");
            }
        }
        return this.combinedKeystore;
    }

    private KeyStore mergeKeystores(KeyStore keyStore, KeyStore keyStore2) throws KeyStoreException {
        if (keyStore2 == null) {
            return keyStore;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        this.addAllCertificates(keyStore, arrayList);
        this.addAllCertificates(keyStore2, arrayList);
        return SSLManagerFactory.createKeyStore((X509Certificate[])arrayList.toArray(new X509Certificate[arrayList.size()]));
    }

    private void addAllCertificates(KeyStore keyStore, List<X509Certificate> list) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            list.add((X509Certificate)keyStore.getCertificate(string));
        }
    }

    /* synthetic */ ImpaxEECertificate(ImpaxEECertificate impaxEECertificate) {
        this();
    }

    private static class LazyHolder {
        private static final ImpaxEECertificate instance = new ImpaxEECertificate(null);

        private LazyHolder() {
        }
    }
}

