/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login.serviceTools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.ILogin;
import com.agfa.pacs.login.LoginFactory;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.security.permission.AuditingPermissions;
import com.agfa.pacs.security.permission.IPermission;
import com.agfa.pacs.security.permission.IPermissions;
import com.agfa.pacs.security.role.IRole;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.agfa.pacs.services.IHTTPClientService;
import com.agfa.pacs.tools.URLEncodeUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AdminPermissions
extends AuditingPermissions {
    private Map<String, Boolean> overridenPermission = new HashMap<String, Boolean>();
    private IPermissions original = null;

    public AdminPermissions(IPermissions iPermissions) {
        this.original = iPermissions;
    }

    public void setOriginalPermission(IPermissions iPermissions) {
        this.original = iPermissions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initializeAndCheck(String string) {
        try {
            InputStream inputStream;
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Agility/userconfiguration");
            ILogin iLogin = LoginFactory.getInstance().getLoginFactories().get(0);
            List<IRole> list = iLogin.retrieveRoles(URLProviderFactory.getProvider());
            if (list == null) {
                return false;
            }
            if (list.size() > 1) {
                IRole iRole = RoleManagerFactory.showRoleChooserDialog(list, (boolean)true);
                if (iRole == null) {
                    return false;
                }
                stringBuilder.append("?preferredRole=");
                stringBuilder.append(URLEncodeUtil.encode((String)iRole.getFullPath()));
            }
            if ((inputStream = ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasStream(stringBuilder.toString(), () -> Collections.singletonMap("Cookie", string))) == null) {
                return false;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("item");
            int n = 0;
            while (true) {
                if (n >= nodeList.getLength()) {
                    return this.isAllowed("Configuration/Security/Impersonate");
                }
                String string2 = nodeList.item(n).getAttributes().getNamedItem("name").getNodeValue();
                String[] stringArray = string2.split("\\|");
                if (stringArray.length == 2 && stringArray[1].startsWith(".listtext.permissions")) {
                    try {
                        String string3 = stringArray[1].replace(".listtext.permissions.", "");
                        String string4 = nodeList.item(n).getTextContent();
                        this.setPermission(string3, Boolean.parseBoolean(string4));
                    }
                    catch (RuntimeException runtimeException) {}
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ALogger.getLogger(AdminPermissions.class).warn("Admin login failed", (Throwable)exception);
            return false;
        }
    }

    public Set<String> getAllPermissions() {
        return this.original.getAllPermissions();
    }

    public String getLocalizedName(String string) {
        return this.original.getLocalizedName(string);
    }

    public IPermission getPermission(String string) {
        return this.original.getPermission(string);
    }

    public boolean isAllowed(String string, List<IAdaptable> list) {
        return false;
    }

    public boolean isAllowed(String string) {
        String string2 = string;
        while (string2.length() > 0) {
            if (this.overridenPermission.containsKey(string2)) {
                return this.overridenPermission.get(string2);
            }
            int n = string2.lastIndexOf(47);
            if (string2.equalsIgnoreCase("Configuration/Security") || n <= 0) break;
            string2 = string2.substring(0, n);
        }
        if (this.original == null) {
            return false;
        }
        return this.original.isAllowed(string);
    }

    public void setPermission(String string, boolean bl) {
        this.overridenPermission.put(string, bl);
    }

    public boolean isAllowedForRole(String string, String string2) {
        return false;
    }

    public Boolean isAllowedForRoleNoCollection(String string, String string2) {
        return false;
    }

    public void modifyPermissionImpl(String string, String string2, boolean bl) {
        throw new UnsupportedOperationException("Not allowed");
    }

    public void removePermissionSettingImpl(String string, String string2) {
        throw new UnsupportedOperationException("Not allowed");
    }
}

