/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class AgeUtil {
    private static final int DICOM_NUMBER_LENGTH = 3;

    static final String formatNumber(long l) {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(l);
        while (stringBuilder.length() < 3) {
            stringBuilder.insert(0, '0');
        }
        return stringBuilder.toString();
    }

    public static String getCurrentAge(Date date) {
        return AgeUtil.getAge(date, LocalDate.now());
    }

    public static String getAge(Date date, LocalDate localDate) {
        return AgeUtil.calculateAge(date, localDate).toString();
    }

    public static String getAge(Date date, Date date2) {
        return AgeUtil.getAge(date, date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static Age calculateAge(Date date, LocalDate localDate) {
        LocalDate localDate2 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return AgeUtil.calculateAge(localDate2, localDate, 13L, 12L, 23L);
    }

    public static Age calculateAge(LocalDate localDate, LocalDate localDate2, long l, long l2, long l3) {
        long l4 = ChronoUnit.DAYS.between(localDate, localDate2);
        if (l4 <= l) {
            return new Age(l4, TimePeriod.Day);
        }
        if ((l4 /= 7L) <= l2) {
            return new Age(l4, TimePeriod.Week);
        }
        Period period = Period.between(localDate, localDate2);
        l4 = period.toTotalMonths();
        if (l4 <= l3) {
            return new Age(l4, TimePeriod.Month);
        }
        l4 = period.getYears();
        return new Age(l4, TimePeriod.Year);
    }

    public static class Age {
        private final long value;
        private final TimePeriod unit;

        Age(long l, TimePeriod timePeriod) {
            this.value = l;
            this.unit = timePeriod;
        }

        public long getValue() {
            return this.value;
        }

        public TimePeriod getUnit() {
            return this.unit;
        }

        public String toString() {
            return AgeUtil.formatNumber(this.value) + this.unit.dicomString;
        }
    }

    public static enum TimePeriod {
        Day("D"),
        Week("W"),
        Month("M"),
        Year("Y");

        private String dicomString;

        private TimePeriod(String string2) {
            this.dicomString = string2;
        }
    }
}

