/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data;

import com.agfa.hap.pacs.data.AgeUtil;
import com.agfa.hap.pacs.data.deidentify.BasicProfileDelete;
import com.agfa.hap.pacs.data.deidentify.BasicProfileReplace;
import com.agfa.hap.pacs.data.deidentify.BasicProfileUID;
import com.agfa.hap.pacs.data.deidentify.CryptoKey;
import com.agfa.hap.pacs.data.deidentify.DicomDeidentificationCodes;
import com.agfa.hap.pacs.data.deidentify.SafePrivateTags;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeGlossary;
import com.agfa.pacs.data.shared.dicom.YesNo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.StandardElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizeImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AnonymizeImpl.class);
    public static final String REPLACEMENT = "REPLACEMENT";
    public static final String CONDITIONAL_REPLACEMENT = "CONDITIONAL_REPLACEMENT";
    public static final String RETAIN_SEX = "RETAIN_SEX";
    public static final String RETAIN_AGE = "RETAIN_AGE";
    public static final String RETAIN_DESCRIPTIONS = "RETAIN_DESCRIPTIONS";
    public static final String RETAIN_DATES = "RETAIN_DATES";
    public static final String RETAIN_ALL_DATA = "RETAIN_ALL_DATA";
    public static final String RETAIN_DIMENSIONS = "RETAIN_DIMENSIONS";
    public static final String RETAIN_PRIVATE_TAGS = "RETAIN_PRIVATE_TAGS";
    public static final String ENCRYPT_IDS = "ENCRYPT_IDS";
    public static final String RECODE_UIDS = "RECODE_UIDS";
    private static final int[] PRESERVED_TAGS = new int[]{524312, 524368, 0x100020, 0x100021, 0x20000D, 0x20000E};
    public static final String EXCLUDE_OWN_SC = "EXCLUDE_OWN_SC";
    private static final String ANONYMOUS_PERSON = "Anonymous^Person";
    public static final String SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT = "SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT";
    private Map<String, PersonDeidentifier> map = new HashMap<String, PersonDeidentifier>();
    private Map<String, String> centralUIDMap = new ConcurrentHashMap<String, String>();
    private Attributes replacement = null;
    private Attributes conditionalReplacement = null;
    private boolean retainPatientAge;
    private boolean retainPatientNumbers = true;
    private boolean retainPatientSex;
    private boolean retainDescription;
    private boolean retainDates;
    private boolean retainPrivateTags;
    private boolean retainAllPatientData;
    private boolean recodeUIDs;
    private boolean encryptOriginalUIDs;
    private Cipher cipher;
    private int patientCount = 0;
    private static int[] ADDITIONAL_REMOVE_TAGS = null;
    private static final char[] RANDOM_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'Q', 'X', 'Y', 'Z'};
    private final Map<Integer, ACTION> allTags = new HashMap<Integer, ACTION>();

    public static void setAdditionalTagsToBeRemoved(int[] nArray) {
        ADDITIONAL_REMOVE_TAGS = Arrays.copyOf(nArray, nArray.length);
    }

    public void setRetainPatientAge(boolean bl) {
        this.retainPatientAge = bl;
    }

    public void setRetainPatientNumbers(boolean bl) {
        this.retainPatientNumbers = bl;
    }

    public void setRetainDates(boolean bl) {
        this.retainDates = bl;
    }

    public void setRetainPrivateTags(boolean bl) {
        this.retainPrivateTags = bl;
    }

    public void setEncryptOriginalUIDs(boolean bl) {
        this.encryptOriginalUIDs = bl;
    }

    public void setRetainAllPatientData(boolean bl) {
        this.retainAllPatientData = bl;
    }

    public void fillUIDMap(Map<String, String> map) {
        for (PersonDeidentifier personDeidentifier : this.map.values()) {
            personDeidentifier.fillUIDMap(map);
        }
        this.centralUIDMap.putAll(map);
    }

    private String getPatientKey(Attributes attributes) {
        String string = attributes.getString(0x100020);
        String string2 = attributes.getString(0x100021);
        if (string2 != null) {
            string = String.valueOf(string) + string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deidentify(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String string = this.getPatientKey(attributes);
        PersonDeidentifier personDeidentifier = this.map.get(string);
        if (personDeidentifier != null) {
            personDeidentifier.deidentify(attributes);
            return;
        }
        Map<String, PersonDeidentifier> map = this.map;
        synchronized (map) {
            personDeidentifier = this.map.get(string);
            if (personDeidentifier != null) {
                personDeidentifier.deidentify(attributes);
                return;
            }
            personDeidentifier = new PersonDeidentifier(this.replacement == null ? null : new Attributes(this.replacement), attributes);
            personDeidentifier.fillUIDMap(this.centralUIDMap);
            this.map.put(string, personDeidentifier);
        }
        personDeidentifier.deidentify(attributes);
    }

    public Attributes getDeidentifiedAttributes(Attributes attributes) {
        this.deidentify(attributes);
        return attributes;
    }

    public void finishProcessing() {
    }

    public void conditionalCopyTo(Attributes attributes) {
        if (this.conditionalReplacement != null) {
            attributes.addSelected(this.conditionalReplacement, attributes);
        }
    }

    public void cleanUp() {
        this.replacement = null;
        this.map = null;
        this.centralUIDMap = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static boolean isAnonymizing(Properties properties) {
        return properties.containsKey(CONDITIONAL_REPLACEMENT) || properties.containsKey(REPLACEMENT) || properties.containsKey(RECODE_UIDS);
    }

    private boolean getPropertyBoolean(Properties properties, String string) {
        Object object = properties.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        LOG.warn("Unknown type of property {} - {}", (Object)string, object.getClass());
        return false;
    }

    public void prepareProcessing(Properties properties) {
        if (properties.containsKey(REPLACEMENT)) {
            this.replacement = (Attributes)properties.get(REPLACEMENT);
        }
        if (properties.containsKey(RETAIN_SEX)) {
            this.retainPatientSex = this.getPropertyBoolean(properties, RETAIN_SEX);
        }
        if (properties.containsKey(RETAIN_AGE)) {
            this.retainPatientAge = this.getPropertyBoolean(properties, RETAIN_AGE);
        }
        if (properties.containsKey(RETAIN_DESCRIPTIONS)) {
            this.retainDescription = this.getPropertyBoolean(properties, RETAIN_DESCRIPTIONS);
        }
        if (properties.containsKey(RETAIN_DATES)) {
            this.retainDates = this.getPropertyBoolean(properties, RETAIN_DATES);
        }
        if (properties.containsKey(RETAIN_DIMENSIONS)) {
            this.retainPatientNumbers = this.getPropertyBoolean(properties, RETAIN_DIMENSIONS);
        }
        if (properties.containsKey(RETAIN_ALL_DATA)) {
            this.retainAllPatientData = this.getPropertyBoolean(properties, RETAIN_ALL_DATA);
        }
        if (properties.containsKey(CONDITIONAL_REPLACEMENT)) {
            this.conditionalReplacement = (Attributes)properties.get(CONDITIONAL_REPLACEMENT);
        }
        if (properties.containsKey(ENCRYPT_IDS)) {
            this.encryptOriginalUIDs = this.getPropertyBoolean(properties, ENCRYPT_IDS);
        }
        if (properties.containsKey(RECODE_UIDS)) {
            this.recodeUIDs = this.getPropertyBoolean(properties, RECODE_UIDS);
        }
        if (properties.containsKey(RETAIN_PRIVATE_TAGS)) {
            this.retainPrivateTags = this.getPropertyBoolean(properties, RETAIN_PRIVATE_TAGS);
        }
        if (!this.retainAllPatientData) {
            this.recodeUIDs = true;
        }
        if (properties.containsKey(EXCLUDE_OWN_SC) && !((Boolean)properties.get(EXCLUDE_OWN_SC)).booleanValue()) {
            properties.put(SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT, Boolean.TRUE);
        }
        if (this.retainAllPatientData && this.recodeUIDs) {
            int[] nArray = BasicProfileUID.TO_RECODE;
            int n = BasicProfileUID.TO_RECODE.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                this.allTags.put(n3, ACTION.UID);
                ++n2;
            }
            if (this.replacement == null) {
                this.allTags.remove(0x20000D);
            }
        } else if (!this.retainAllPatientData) {
            int n;
            int[] nArray = BasicProfileReplace.TAGS_TO_CLEAR;
            int n4 = BasicProfileReplace.TAGS_TO_CLEAR.length;
            int n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.Clear);
                ++n5;
            }
            nArray = BasicProfileDelete.TAGS_TO_DELETE;
            n4 = BasicProfileDelete.TAGS_TO_DELETE.length;
            n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.Remove);
                ++n5;
            }
            if (ADDITIONAL_REMOVE_TAGS != null) {
                nArray = ADDITIONAL_REMOVE_TAGS;
                n4 = ADDITIONAL_REMOVE_TAGS.length;
                n5 = 0;
                while (n5 < n4) {
                    n = nArray[n5];
                    this.allTags.put(n, ACTION.Remove);
                    ++n5;
                }
            }
            nArray = BasicProfileUID.TO_RECODE;
            n4 = BasicProfileUID.TO_RECODE.length;
            n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.UID);
                ++n5;
            }
            nArray = BasicProfileReplace.TAGS_TO_REPLACE;
            n4 = BasicProfileReplace.TAGS_TO_REPLACE.length;
            n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.Replace);
                ++n5;
            }
            if (this.retainDescription) {
                this.allTags.remove(528432);
                this.allTags.remove(528446);
            }
            if (this.retainPatientSex) {
                this.allTags.remove(0x100040);
            }
        }
    }

    public void process(Attributes attributes) {
        if (this.replacement != null || this.conditionalReplacement != null || this.retainAllPatientData && this.recodeUIDs) {
            this.deidentify(attributes);
        }
    }

    public boolean shouldProcess() {
        return this.replacement != null || this.conditionalReplacement != null || this.retainAllPatientData && this.recodeUIDs;
    }

    private static enum ACTION {
        Clear,
        Remove,
        UID,
        Replace;

    }

    private class PersonDeidentifier {
        private Attributes patientReplacement = null;
        private final Map<String, String> uidMap = new Hashtable<String, String>();
        private final Map<String, String> nonUIDReplacement = new Hashtable<String, String>();
        private final Map<String, Attributes> studyReplacements = new Hashtable<String, Attributes>();
        private final long shiftInSecs;

        public PersonDeidentifier(Attributes attributes, Attributes attributes2) {
            this.patientReplacement = attributes;
            this.shiftInSecs = ThreadLocalRandom.current().nextLong(126144000L);
            this.setPatientID();
        }

        private void setPatientID() {
            if (AnonymizeImpl.this.retainAllPatientData && (this.patientReplacement == null || !this.patientReplacement.containsValue(0x100020))) {
                return;
            }
            String string = AnonymizeImpl.this.patientCount == 0 ? (this.patientReplacement.containsValue(0x100020) ? this.patientReplacement.getString(0x100020) : "") : (!this.patientReplacement.containsValue(0x100020) ? Integer.toString(AnonymizeImpl.this.patientCount) : String.valueOf(this.patientReplacement.getString(0x100020)) + "_" + Integer.toString(AnonymizeImpl.this.patientCount));
            this.patientReplacement.setString(0x100020, VR.LO, string);
            AnonymizeImpl anonymizeImpl = AnonymizeImpl.this;
            anonymizeImpl.patientCount = anonymizeImpl.patientCount + 1;
        }

        public void fillUIDMap(Map<String, String> map) {
            this.uidMap.putAll(map);
        }

        public void deidentify(Attributes attributes) {
            String string = attributes.getString(0x20000D);
            Attributes attributes2 = this.studyReplacements.get(string);
            if (attributes2 == null) {
                attributes2 = this.createStudyReplacement(attributes, string);
            }
            Attributes attributes3 = new Attributes(attributes, PRESERVED_TAGS);
            this.deidentifyImpl(attributes, attributes);
            this.handleReplacements(attributes, attributes2, attributes3);
        }

        private void deidentifyImpl(Attributes attributes, Attributes attributes2) {
            int[] nArray = attributes2.tags();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (attributes2.containsValue(n3)) {
                    ACTION aCTION = this.isDefaultDeidentificationActionIgnored(attributes, n3) ? null : (ACTION)((Object)AnonymizeImpl.this.allTags.get(n3));
                    VR vR = ElementDictionary.vrOf((int)n3, null);
                    if (aCTION != null) {
                        this.replace(attributes2, n3, vR, aCTION);
                    } else if (vR == VR.DT) {
                        this.anonymizeDT(attributes2, n3);
                    } else if (vR == VR.DA) {
                        this.anonymizeDA(attributes2, n3);
                    } else if (vR == VR.TM) {
                        this.anonymizeTM(attributes2, n3);
                    } else if (vR == VR.SQ) {
                        Sequence sequence = attributes2.getSequence(n3);
                        if (sequence != null && !sequence.isEmpty()) {
                            int n4 = 0;
                            while (n4 < sequence.size()) {
                                Attributes attributes3 = (Attributes)sequence.get(n4);
                                this.deidentifyImpl(attributes, attributes3);
                                ++n4;
                            }
                        }
                    } else if (!AnonymizeImpl.this.retainPrivateTags && TagUtils.isPrivateGroup((int)n3) && !TagUtils.isPrivateCreator((int)n3)) {
                        vR = attributes2.getVR(n3);
                        switch (vR) {
                            case DS: 
                            case FD: 
                            case FL: 
                            case IS: 
                            case SQ: 
                            case SS: 
                            case UL: 
                            case US: {
                                break;
                            }
                            default: {
                                if (SafePrivateTags.isSafeTag(n3, attributes2.privateCreatorOf(n3))) break;
                                attributes2.remove(n3);
                            }
                        }
                    }
                }
                ++n2;
            }
        }

        private void handleReplacements(Attributes attributes, Attributes attributes2, Attributes attributes3) {
            if (this.patientReplacement != null) {
                attributes.addAll(this.patientReplacement);
            }
            if (attributes2 != null && !attributes2.isEmpty()) {
                attributes.addAll(attributes2);
            }
            AnonymizeImpl.this.conditionalCopyTo(attributes);
            if (AnonymizeImpl.this.retainAllPatientData) {
                this.removeNullElements(attributes);
            }
            attributes.setString(1179746, VR.CS, YesNo.Yes.dicom());
            Sequence sequence = attributes.newSequence(1179748, 3);
            sequence.add(DicomDeidentificationCodes.BASIC_PROFILE.toDataset());
            if (AnonymizeImpl.this.retainPatientAge || AnonymizeImpl.this.retainPatientSex || AnonymizeImpl.this.retainPatientNumbers) {
                sequence.add(DicomDeidentificationCodes.RETAIN_PATIENT_CHARACTERISTICS.toDataset());
            }
            if (!AnonymizeImpl.this.retainDescription) {
                sequence.add(DicomDeidentificationCodes.CLEAN_DESCRIPTORS.toDataset());
            }
            if (!AnonymizeImpl.this.retainPrivateTags) {
                sequence.add(DicomDeidentificationCodes.RETAIN_SAFE_PRIVATE_TAGS.toDataset());
            }
            sequence.add(DicomDeidentificationCodes.RETAIN_MODIFIED_DATES.toDataset());
            attributes.setString(2622211, VR.CS, "MODIFIED");
            if (AnonymizeImpl.this.encryptOriginalUIDs) {
                Sequence sequence2 = attributes.ensureSequence(0x4000500, 1);
                Attributes attributes4 = new Attributes();
                attributes4.setString(67110160, VR.UI, "1.2.840.10008.1.2");
                this.getEncryptedData(attributes3).ifPresent(byArray -> {
                    Object object = attributes4.setBytes(67110176, VR.OB, byArray);
                });
                sequence2.add(attributes4);
            }
        }

        private boolean isDefaultDeidentificationActionIgnored(Attributes attributes, int n) {
            block14: {
                if (n != 4237104) break block14;
                switch (attributes.getString(524310)) {
                    case "1.2.840.10008.5.1.4.1.1.88.50": 
                    case "1.2.840.10008.5.1.4.1.1.88.65": 
                    case "1.2.840.10008.5.1.4.1.1.88.69": {
                        return true;
                    }
                    case "1.2.840.10008.5.1.4.1.1.88.11": {
                        return this.isMammoPreprocessingReport(attributes);
                    }
                }
            }
            return false;
        }

        private boolean isMammoPreprocessingReport(Attributes attributes) {
            return CodeGlossary.MAMMO_PREPROCESSING_REPORT.equals(Code.create(attributes, 4235331));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Optional<byte[]> getEncryptedData(Attributes attributes) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                    try {
                        Optional<byte[]> optional;
                        block18: {
                            DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)byteArrayOutputStream, "1.2.840.10008.1.2");
                            try {
                                dicomOutputStream.writeDataset(null, attributes);
                                dicomOutputStream.close();
                                byte[] byArray = byteArrayOutputStream.toByteArray();
                                if (AnonymizeImpl.this.cipher == null) {
                                    AnonymizeImpl.this.cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                                    Optional<PublicKey> optional2 = CryptoKey.getPublicKey();
                                    if (optional2.isPresent()) {
                                        AnonymizeImpl.this.cipher.init(1, optional2.get());
                                    }
                                }
                                optional = Optional.of(AnonymizeImpl.this.cipher.doFinal(byArray));
                                return optional;
                            }
                            finally {
                                if (dicomOutputStream == null) break block18;
                                dicomOutputStream.close();
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        return optional;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (byteArrayOutputStream == null) throw throwable;
                        byteArrayOutputStream.close();
                        throw throwable;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
                LOG.error("Could not encrypt data", (Throwable)exception);
                return Optional.empty();
            }
        }

        private void anonymizeDT(Attributes attributes, int n) {
            if (AnonymizeImpl.this.retainDates) {
                return;
            }
            Date date = attributes.getDate(n);
            if (date != null) {
                Instant instant = date.toInstant();
                instant = instant.minus(this.shiftInSecs, ChronoUnit.SECONDS);
                attributes.setDate((long)n, Date.from(instant));
            }
        }

        private void anonymizeDATM(Attributes attributes, int n, int n2) {
            if (AnonymizeImpl.this.retainDates) {
                return;
            }
            long l = ((long)n << 32) + (long)n2;
            Date date = attributes.getDate(l);
            if (date == null) {
                this.removeDateTime(attributes, l);
            } else {
                Instant instant = date.toInstant();
                instant = instant.minus(this.shiftInSecs, ChronoUnit.SECONDS);
                attributes.setDate(l, Date.from(instant));
            }
        }

        private void anonymizeTM(Attributes attributes, int n) {
            Date date;
            if (AnonymizeImpl.this.retainDates) {
                return;
            }
            int n2 = StandardElementDictionary.getStandardElementDictionary().daTagOf(n);
            if (n2 == 0 && (date = attributes.getDate(n)) != null) {
                Instant instant = date.toInstant();
                instant = instant.minus(this.shiftInSecs, ChronoUnit.SECONDS);
                attributes.setDate(n, VR.TM, new Date[]{Date.from(instant)});
            }
        }

        private void anonymizeDA(Attributes attributes, int n) {
            int n2 = StandardElementDictionary.getStandardElementDictionary().tmTagOf(n);
            if (n2 == 0) {
                Date date = attributes.getDate(n);
                if (date != null) {
                    Instant instant = date.toInstant();
                    instant = instant.minus(this.shiftInSecs, ChronoUnit.SECONDS);
                    attributes.setDate(n, VR.DA, new Date[]{Date.from(instant)});
                }
            } else {
                this.anonymizeDATM(attributes, n, n2);
            }
        }

        private void removeDateTime(Attributes attributes, long l) {
            attributes.remove((int)(l & 0xFFFFFFFFFFFFFFFFL));
            attributes.remove((int)(l >> 32));
        }

        private synchronized Attributes createStudyReplacement(Attributes attributes, String string) {
            Attributes attributes2 = new Attributes();
            if (AnonymizeImpl.this.retainPatientAge) {
                Date date = null;
                Date date2 = null;
                if (attributes.containsValue(0x100030) && attributes.containsValue(524320)) {
                    date = Dcm4cheUtils.getDateTime(2251937253163056L, attributes);
                    date2 = Dcm4cheUtils.getDateTime(4503805786849330L, attributes);
                }
                if (date != null && date2 != null) {
                    try {
                        attributes2.setString(0x101010, VR.AS, AgeUtil.getAge(date2, date));
                    }
                    catch (Exception exception) {
                        LOG.warn("Could not calculate patient age", (Throwable)exception);
                    }
                } else if (attributes.containsValue(0x101010)) {
                    attributes2.addSelected(attributes, new int[]{0x101010});
                }
            }
            if (AnonymizeImpl.this.retainPatientNumbers) {
                attributes2.addSelected(attributes, new int[]{0x101020, 0x101030});
            }
            this.studyReplacements.put(string, attributes2);
            return attributes2;
        }

        private void replace(Attributes attributes, int n, VR vR, ACTION aCTION) {
            if (this.patientReplacement != null && this.patientReplacement.contains(n)) {
                attributes.setString(n, vR, this.patientReplacement.getString(n));
                return;
            }
            block0 : switch (aCTION) {
                case Remove: {
                    attributes.remove(n);
                    break;
                }
                case Clear: {
                    attributes.setNull(n, vR);
                    break;
                }
                case UID: {
                    String string2 = attributes.getString(n);
                    String string3 = this.uidMap.computeIfAbsent(string2, string -> UIDUtils.createUID());
                    attributes.setString(n, vR, string3);
                    break;
                }
                case Replace: {
                    switch (vR) {
                        case PN: {
                            attributes.setString(n, vR, AnonymizeImpl.ANONYMOUS_PERSON);
                            break block0;
                        }
                        case SQ: {
                            attributes.getSequence(n).clear();
                            break block0;
                        }
                    }
                    String string4 = attributes.getString(n);
                    String string5 = this.nonUIDReplacement.computeIfAbsent(string4, string -> this.createRandomString((String)string, vR));
                    attributes.setString(n, vR, string5);
                }
            }
        }

        private void removeNullElements(Attributes attributes) {
            if (this.patientReplacement != null) {
                int[] nArray = this.patientReplacement.tags();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    if (!this.patientReplacement.containsValue(n3)) {
                        attributes.remove(n3);
                    }
                    ++n2;
                }
            }
        }

        private String createRandomString(String string, VR vR) {
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            if (vR.code() == VR.PN.code()) {
                int n = 0;
                while (n < string.length()) {
                    stringBuilder.append(string.charAt(n) == '^' || string.charAt(n) == '=' ? string.charAt(n) : RANDOM_CHARS[((Random)threadLocalRandom).nextInt(26)]);
                    ++n;
                }
            } else if (vR.isIntType()) {
                stringBuilder.append(((Random)threadLocalRandom).nextInt(9) + 1);
                int n = 1;
                while (n < string.length()) {
                    stringBuilder.append(((Random)threadLocalRandom).nextInt(10));
                    ++n;
                }
            } else {
                int n = 0;
                while (n < string.length()) {
                    stringBuilder.append(RANDOM_CHARS[((Random)threadLocalRandom).nextInt(26)]);
                    ++n;
                }
            }
            return stringBuilder.toString();
        }
    }
}

