/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data;

import com.agfa.hap.pacs.data.MPPSMessage;
import com.agfa.pacs.data.shared.code.Code;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCoercerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(DataCoercerImpl.class);
    public static final String MWL_ITEM = "MWL_ITEM";
    public static final String MWL_NODE = "MWL_NODE";
    public static final String DEFAULT_COERCION = "DEFAULT_COERCION";
    private static final String STUDY_TO_ACCESSION_NUMBER = "studyToAccessionNumber";
    public static final String SERIES_COERCION = "SERIES_COERCION";
    public static final String OBJECT_COERCION = "OBJECT_COERCION";
    public static final String SEND_MPPS = "sendMpps";
    protected static final String PROTOCOL_NAME = "Import";
    protected static final String DEFAULT_STUDY_UID = "XX";
    private final String productName;
    private final String stationAET;
    private final boolean studyUIDFromMWL;
    private Attributes mwlItem = null;
    private Map<String, ImportingInformation> importObjects = new Hashtable<String, ImportingInformation>();
    private Attributes defaultCoercion;
    private Map<String, Attributes> seriesCoercion = null;
    private Map<String, Attributes> objectCoercion = null;
    private String targetAET;
    private Map<String, String> study2accNRMap;

    public DataCoercerImpl(String string, String string2) {
        this(string, string2, false);
    }

    public DataCoercerImpl(String string, String string2, boolean bl) {
        this.productName = string;
        this.stationAET = string2;
        this.studyUIDFromMWL = bl;
    }

    public List<MPPSMessage> prepareProcessing(Properties properties, Map<Attributes, List<Attributes>> map, String string) {
        this.mwlItem = (Attributes)properties.get(MWL_ITEM);
        this.defaultCoercion = (Attributes)properties.get(DEFAULT_COERCION);
        this.seriesCoercion = (Map)properties.get(SERIES_COERCION);
        this.objectCoercion = (Map)properties.get(OBJECT_COERCION);
        this.targetAET = string;
        this.study2accNRMap = (Map)properties.get(STUDY_TO_ACCESSION_NUMBER);
        if (this.studyUIDFromMWL) {
            LOG.info("Creating new Study Instance UIDs for imported studies");
        }
        if (!map.isEmpty()) {
            ArrayList<MPPSMessage> arrayList = new ArrayList<MPPSMessage>();
            for (Map.Entry<Attributes, List<Attributes>> entry : map.entrySet()) {
                ImportingInformation importingInformation = new ImportingInformation(string);
                this.importObjects.put(entry.getKey().getString(0x20000D), importingInformation);
                if (this.mwlItem != null) {
                    DataCoercerImpl.prepareReplacementDataset(this.mwlItem, importingInformation, entry.getKey(), this.studyUIDFromMWL, this.productName);
                } else if (this.studyUIDFromMWL) {
                    String string2 = UIDUtils.createUID();
                    importingInformation.studyReplacement.setString(0x20000D, VR.UI, string2);
                    importingInformation.mpps.setString(0x20000D, VR.UI, string2);
                }
                arrayList.add(this.createMPPS(importingInformation, entry.getKey(), entry.getValue(), string));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static Attributes performMWLCoercion(Attributes attributes, Attributes attributes2, boolean bl) {
        ImportingInformation importingInformation = new ImportingInformation(null);
        DataCoercerImpl.prepareReplacementDataset(attributes2, importingInformation, attributes, bl, "");
        Attributes attributes3 = new Attributes(attributes);
        importingInformation.applyReplacementDatasetsTo(attributes3);
        return attributes3;
    }

    private Attributes getImportCode() {
        return new Code("DCM", "IMPORT", null, "Import Action").toDataset();
    }

    private MPPSMessage createMPPS(ImportingInformation importingInformation, Attributes attributes, List<Attributes> list, String string) {
        Object object3;
        Object object2;
        Attributes attributes2 = importingInformation.mpps;
        if (attributes2.containsValue(0x400100) && !(object2 = (Attributes)attributes2.getSequence(0x400100).get(0)).containsValue(3280996)) {
            object2.newSequence(3280996, 1).add(this.getImportCode());
        }
        if (!attributes2.containsValue(4194928)) {
            object2 = new Attributes();
            if (attributes == null) {
                object2.addSelected(importingInformation.getStudyData(), new int[]{524368, 0x20000D});
            } else {
                object2.addSelected(attributes, new int[]{524368, 0x20000D});
            }
            object2.newSequence(0x400100, 1).add(this.getImportCode());
            attributes2.newSequence(4194928, 1).add(object2);
        }
        if (this.study2accNRMap != null && attributes != null && (object2 = this.study2accNRMap.get(attributes.getString(0x20000D))) != null) {
            ((Attributes)attributes2.ensureSequence(4194928, 1).get(0)).setString(524368, VR.SH, (String)object2);
        }
        object2 = null;
        Sequence sequence = attributes2.newSequence(0x400340, 10);
        if (attributes != null) {
            for (Object object3 : list) {
                if (object2 == null) {
                    object2 = object3.getString(524384);
                }
                if (object3.getSequence(0x400220) == null) {
                    object3.newSequence(0x400220, 0);
                }
                sequence.add(object3);
            }
        } else {
            for (Object object3 : importingInformation.seriesMap.values()) {
                if (object2 == null) {
                    object2 = object3.getString(524384);
                }
                sequence.add(object3);
            }
        }
        attributes2.setString(524384, VR.CS, (String)object2);
        if (!attributes2.containsValue(4194899)) {
            attributes2.setString(4194899, VR.SH, "1");
        }
        object3 = new Date();
        attributes2.setDate(18016889594708549L, (Date)object3);
        attributes2.setString(4194881, VR.AE, this.getStationAET());
        attributes2.setString(4194898, VR.CS, "IN PROGRESS");
        return new MPPSMessage(importingInformation.targetAET, attributes2, true);
    }

    private String getStationAET() {
        return this.stationAET;
    }

    private static void prepareReplacementDataset(Attributes attributes, ImportingInformation importingInformation, Attributes attributes2, boolean bl, String string) {
        Attributes attributes3;
        Sequence sequence;
        Object object;
        String string2;
        Attributes attributes4 = importingInformation.studyReplacement;
        Attributes attributes5 = new Attributes();
        importingInformation.mpps.addAll(attributes);
        Attributes attributes6 = importingInformation.mpps;
        DataCoercerImpl.copyOver(attributes4, 524293, attributes, attributes5, attributes2);
        DataCoercerImpl.copyOver(attributes4, 0x100010, attributes, attributes5, attributes2);
        DataCoercerImpl.copyOver(attributes4, 0x100020, attributes, attributes5, attributes2);
        DataCoercerImpl.copyOver(attributes4, 0x100021, attributes, attributes5, attributes2);
        DataCoercerImpl.mergeOtherPatientIDs(attributes4, attributes, attributes2, attributes5);
        DataCoercerImpl.copyOver(attributes4, 0x100030, attributes, attributes5, attributes2);
        DataCoercerImpl.copyOver(attributes4, 0x100040, attributes, attributes5, attributes2);
        DataCoercerImpl.mergeSequence(attributes4, 528656, attributes, attributes2);
        attributes4.addSelected(attributes, new int[]{524368});
        attributes5.addSelected(attributes2, new int[]{524368});
        Attributes attributes7 = new Attributes();
        DataCoercerImpl.copyOver(attributes7, 0x401001, attributes, attributes5, attributes2);
        DataCoercerImpl.copyOver(attributes7, 3280992, attributes, attributes5, attributes2);
        DataCoercerImpl.copySPSID(attributes7, attributes);
        DataCoercerImpl.copyOver(attributes7, 0x400009, attributes, attributes5, attributes2);
        attributes7.addSelected(attributes2, new int[]{0x400007});
        attributes4.newSequence(4194933, 1).add(attributes7);
        attributes4.setString(0x200010, VR.SH, attributes.getString(0x401001));
        if (attributes2.contains(0x200010)) {
            attributes6.addSelected(attributes2, new int[]{0x200010});
        } else {
            string2 = attributes.getString(0x401001);
            attributes6.setString(0x200010, VR.SH, string2);
            attributes4.setString(0x200010, VR.SH, string2);
        }
        attributes6.addSelected(attributes2, new int[]{4194899, 4194900});
        DataCoercerImpl.copySeq(attributes4, 3280996, 528434, attributes);
        attributes6.addSelected(attributes4, new int[]{528434});
        string2 = new Attributes(attributes6, new int[]{524310, 524312});
        attributes4.newSequence(528657, 1).add((Attributes)string2);
        if (!bl && attributes2.containsValue(0x20000D)) {
            attributes6.addSelected(attributes2, new int[]{0x20000D});
        } else if (attributes.containsValue(0x20000D)) {
            attributes4.addSelected(attributes, new int[]{0x20000D});
            attributes6.addSelected(attributes, new int[]{0x20000D});
        } else {
            object = UIDUtils.createUID();
            attributes4.setString(0x20000D, VR.UI, (String)object);
            attributes6.setString(0x20000D, VR.UI, (String)object);
        }
        object = attributes2.getDate(2251937253163056L);
        if (object == null) {
            if (attributes6.containsValue(524320)) {
                object = attributes6.getDate(2251937253163056L);
            } else {
                sequence = attributes.getSequence(0x400100);
                if (sequence != null && !sequence.isEmpty() && (attributes3 = (Attributes)sequence.get(0)).containsValue(0x400002)) {
                    object = attributes3.getDate(18014407103610883L);
                }
                if (object == null) {
                    object = new Date();
                }
            }
            attributes4.setDate(2251937253163056L, (Date)object);
        }
        attributes6.setDate(2251937253163056L, (Date)object);
        if (!attributes2.contains(528432) && attributes6.contains(528432)) {
            attributes4.addSelected(attributes6, new int[]{528432});
        }
        attributes4.addSelected(attributes2, new int[]{528432});
        sequence = new Attributes();
        sequence.addSelected(attributes6, new int[]{524368, 0x20000D});
        sequence.addSelected(attributes2, new int[]{528656});
        if (attributes4.contains(4194933)) {
            sequence.addAll(attributes4.getNestedDataset(4194933));
        }
        DataCoercerImpl.copySeq((Attributes)sequence, 0x400008, attributes);
        attributes6.newSequence(4194928, 2).add((Attributes)sequence);
        attributes6.remove(524368);
        attributes3 = importingInformation.originalAttributesSequenceItem;
        attributes3.setDate(67110242, VR.DT, new Date[]{new Date()});
        attributes3.setString(67110243, VR.CS, string);
        attributes3.setString(67110245, VR.CS, "COERCE");
        attributes3.newSequence(0x4000550, 1).add(attributes5);
    }

    private static void copySPSID(Attributes attributes, Attributes attributes2) {
        Sequence sequence = attributes2.getSequence(0x400100);
        if (sequence != null && !sequence.isEmpty() && ((Attributes)sequence.get(0)).contains(0x400009)) {
            attributes.addSelected((Attributes)sequence.get(0), new int[]{0x400009});
        }
    }

    private static void copyOver(Attributes attributes, int n, Attributes attributes2, Attributes attributes3, Attributes attributes4) {
        if (attributes2.contains(n)) {
            attributes.addSelected(attributes2, new int[]{n});
            attributes3.addSelected(attributes4, new int[]{n});
        } else {
            attributes.addSelected(attributes4, new int[]{n});
        }
    }

    private static void copySeq(Attributes attributes, int n, Attributes attributes2) {
        Sequence sequence = attributes2.getSequence(n);
        if (sequence != null) {
            DataCoercerImpl.addSeq(attributes, n, sequence);
        }
    }

    private static void copySeq(Attributes attributes, int n, int n2, Attributes attributes2) {
        Sequence sequence = attributes2.getSequence(n);
        if (sequence != null) {
            DataCoercerImpl.addSeq(attributes, n2, sequence);
        }
    }

    private static void addSeq(Attributes attributes, int n, Sequence sequence) {
        Sequence sequence2 = attributes.newSequence(n, sequence.size());
        int n2 = 0;
        while (n2 < sequence.size()) {
            sequence2.add(new Attributes((Attributes)sequence.get(n2)));
            ++n2;
        }
    }

    private static void mergeOtherPatientIDs(Attributes attributes, Attributes attributes2, Attributes attributes3, Attributes attributes4) {
        String[] stringArray = attributes2.getStrings(0x101000);
        String[] stringArray2 = attributes3.getStrings(0x101000);
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (stringArray != null) {
            String[] stringArray3 = Arrays.copyOf(stringArray2, stringArray2.length + stringArray.length);
            int n = stringArray2.length;
            while (n < stringArray3.length) {
                stringArray3[n] = stringArray[n - stringArray2.length];
                ++n;
            }
            attributes.setString(0x101000, VR.LO, stringArray3);
            if (stringArray2.length != 0) {
                attributes4.setString(0x101000, VR.LO, stringArray2);
            }
        }
    }

    private static void mergeSequence(Attributes attributes, int n, Attributes attributes2, Attributes attributes3) {
        int n2;
        Sequence sequence = attributes2.getSequence(n);
        Sequence sequence2 = attributes3.getSequence(n);
        if (sequence == null && sequence2 == null) {
            return;
        }
        Sequence sequence3 = attributes.newSequence(n, 4);
        if (sequence != null) {
            n2 = 0;
            while (n2 < sequence.size()) {
                sequence3.add(new Attributes((Attributes)sequence.get(n2)));
                ++n2;
            }
        }
        if (sequence2 != null) {
            n2 = 0;
            while (n2 < sequence2.size()) {
                sequence3.add(new Attributes((Attributes)sequence2.get(n2)));
                ++n2;
            }
        }
        if (sequence == null || sequence2 == null) {
            DataCoercerImpl.addSeq(attributes, n, sequence == null ? sequence2 : sequence);
            return;
        }
    }

    public List<MPPSMessage> generateMPPSComplete() {
        ArrayList<MPPSMessage> arrayList = new ArrayList<MPPSMessage>();
        for (ImportingInformation importingInformation : this.importObjects.values()) {
            if (importingInformation.mppsCreationDelayed) {
                arrayList.add(this.createMPPS(importingInformation, null, null, importingInformation.targetAET));
            }
            if (importingInformation.mpps == null) continue;
            Attributes attributes = new Attributes();
            attributes.setString(4194898, VR.CS, "COMPLETED");
            attributes.setDate(18016941134316113L, new Date());
            attributes.addSelected(importingInformation.mpps, new int[]{0x400340});
            attributes.addSelected(importingInformation.mpps, new int[]{524312});
            arrayList.add(new MPPSMessage(importingInformation.targetAET, attributes, false));
        }
        return arrayList;
    }

    public void cleanUp() {
        this.importObjects.clear();
        this.defaultCoercion = null;
        if (this.seriesCoercion != null) {
            this.seriesCoercion.clear();
        }
        if (this.objectCoercion != null) {
            this.objectCoercion.clear();
        }
        this.mwlItem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Attributes attributes) {
        DataCoercerImpl dataCoercerImpl;
        ImportingInformation importingInformation;
        String string = attributes.getString(0x20000D);
        if (string == null) {
            string = DEFAULT_STUDY_UID;
        }
        if ((importingInformation = this.importObjects.get(string)) == null) {
            dataCoercerImpl = this;
            synchronized (dataCoercerImpl) {
                importingInformation = this.importObjects.get(string);
                if (importingInformation == null) {
                    importingInformation = new ImportingInformation(this.targetAET);
                    if (this.mwlItem != null) {
                        DataCoercerImpl.prepareReplacementDataset(this.mwlItem, importingInformation, attributes, this.studyUIDFromMWL, this.productName);
                    }
                    importingInformation.setMPPSDelayed(attributes, this.studyUIDFromMWL ? UIDUtils.createUID() : string, this.study2accNRMap);
                    this.importObjects.put(string, importingInformation);
                }
            }
        }
        if (importingInformation.mppsCreationDelayed) {
            importingInformation.addInstance(attributes);
        }
        importingInformation.applyReplacementDatasetsTo(attributes);
        if (this.defaultCoercion != null) {
            attributes.addAll(this.defaultCoercion);
        }
        if (this.seriesCoercion != null && (dataCoercerImpl = this.seriesCoercion.get(attributes.getString(0x20000E))) != null) {
            attributes.addAll((Attributes)dataCoercerImpl);
        }
        if (this.objectCoercion != null && (dataCoercerImpl = this.objectCoercion.get(attributes.getString(524312))) != null) {
            attributes.addAll((Attributes)dataCoercerImpl);
        }
        return attributes;
    }

    private static class ImportingInformation {
        private final Attributes studyReplacement = new Attributes();
        private final Attributes originalAttributesSequenceItem = new Attributes();
        private final Attributes mpps = new Attributes();
        private boolean mppsCreationDelayed;
        public Map<String, Attributes> seriesMap;
        private Attributes studyData;
        private String targetAET;

        public ImportingInformation(String string) {
            this.mpps.setString(524310, VR.UI, "1.2.840.10008.3.1.2.3.3");
            this.mpps.setString(524312, VR.UI, UIDUtils.createUID());
            this.targetAET = string;
        }

        public void setMPPSDelayed(Attributes attributes, String string, Map<String, String> map) {
            this.mppsCreationDelayed = true;
            this.seriesMap = new Hashtable<String, Attributes>();
            this.studyData = new Attributes(attributes, new int[]{524368, 0x20000D});
            if (!this.studyReplacement.containsValue(0x20000D)) {
                this.studyReplacement.setString(0x20000D, VR.UI, string);
            }
            if (!this.studyData.containsValue(0x20000D)) {
                this.studyData.addSelected(this.studyReplacement, new int[]{0x20000D});
            }
            if (map != null) {
                String string2 = map.get(this.studyData.getString(0x20000D));
                if (string2 == null && string.equals(DataCoercerImpl.DEFAULT_STUDY_UID)) {
                    string2 = map.get("");
                }
                if (string2 != null) {
                    ((Attributes)this.mpps.ensureSequence(4194928, 1).get(0)).setString(524368, VR.SH, string2);
                }
            }
        }

        public Attributes getStudyData() {
            return this.studyData;
        }

        public synchronized void addInstance(Attributes attributes) {
            int n;
            String string = attributes.getString(0x20000E);
            Attributes attributes2 = this.seriesMap.get(string);
            boolean bl = attributes.containsValue(2621444);
            int n2 = n = bl ? 528704 : 0x400220;
            if (attributes2 == null) {
                attributes2 = new Attributes();
                attributes2.addSelected(attributes, new int[]{524384, 528446, 0x20000E});
                attributes2.setString(1577008, VR.LO, DataCoercerImpl.PROTOCOL_NAME);
                attributes2.newSequence(528704, 10);
                attributes2.newSequence(0x400220, 2);
                this.seriesMap.put(string, attributes2);
            }
            Sequence sequence = attributes2.getSequence(n);
            Attributes attributes3 = new Attributes(3);
            attributes3.addSelected(attributes, new int[]{524310, 524312});
            attributes3.setString(524372, VR.AE, this.targetAET);
            sequence.add(attributes3);
        }

        void applyReplacementDatasetsTo(Attributes attributes) {
            attributes.addAll(this.studyReplacement);
            attributes.ensureSequence(67110241, 1).add(new Attributes(this.originalAttributesSequenceItem));
        }
    }
}

