/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ModalityConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModalityConfigUtils.class);

    private ModalityConfigUtils() {
    }

    public static String toXML(DicomEnum ... dicomEnumArray) {
        StringBuilder stringBuilder = new StringBuilder("<list>");
        if (dicomEnumArray != null) {
            DicomEnum[] dicomEnumArray2 = dicomEnumArray;
            int n = dicomEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                DicomEnum dicomEnum = dicomEnumArray2[n2];
                stringBuilder.append("<item name=\"");
                stringBuilder.append(dicomEnum.dicom());
                stringBuilder.append("\"/>");
                ++n2;
            }
        }
        stringBuilder.append("</list>");
        return stringBuilder.toString();
    }

    public static List<String> fromXML(String string) {
        try {
            return ModalityConfigUtils.parseModalities(string);
        }
        catch (Exception exception) {
            LOGGER.warn("Reading modalities from configuration failed", (Throwable)exception);
            return null;
        }
    }

    private static List<String> parseModalities(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = document.getElementsByTagName("item");
            int n = 0;
            while (n < nodeList.getLength()) {
                NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                arrayList.add(namedNodeMap.getNamedItem("name").getNodeValue());
                ++n;
            }
        }
        return arrayList;
    }
}

