/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.deidentify;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoKey {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoKey.class);
    private static final String PUBLIC_RESOURCE_NAME = "public.pem";
    private static final String PUBLIC_PEM_HEADER = "-----BEGIN RSA PUBLIC KEY-----";
    private static final String PUBLIC_PEM_FOOTER = "-----END RSA PUBLIC KEY-----";
    private static final String PRIVATE_PEM_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PRIVATE_PEM_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static final String KEY_ALGORITHM = "RSA";

    public static Optional<PublicKey> getPublicKey() {
        try {
            InputStream inputStream = CryptoKey.class.getResourceAsStream(PUBLIC_RESOURCE_NAME);
            String string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            inputStream.close();
            String string2 = string.replace(PUBLIC_PEM_HEADER, "");
            string2 = string2.replace(PUBLIC_PEM_FOOTER, "");
            string2 = string2.trim();
            string2 = string2.replace("\n", "");
            byte[] byArray = Base64.getDecoder().decode(string2);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return Optional.ofNullable(keyFactory.generatePublic(x509EncodedKeySpec));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
            LOG.error("Could not decode public key", (Throwable)exception);
            return Optional.empty();
        }
    }

    public static Optional<PrivateKey> getPrivateKey(String string) {
        try {
            byte[] byArray = Files.readAllBytes(new File(string).toPath());
            String string2 = new String(byArray);
            String string3 = string2.replace(PRIVATE_PEM_HEADER, "");
            string3 = string3.replace(PRIVATE_PEM_FOOTER, "");
            string3 = string3.trim();
            string3 = string3.replace("\n", "");
            byte[] byArray2 = Base64.getDecoder().decode(string3);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return Optional.ofNullable(keyFactory.generatePrivate(pKCS8EncodedKeySpec));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
            LOG.error("Could not decode private key", (Throwable)exception);
            return Optional.empty();
        }
    }
}

