/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.deidentify;

import com.agfa.hap.pacs.data.deidentify.CryptoKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.io.DicomInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reidentifier {
    private static final Logger LOG = LoggerFactory.getLogger(Reidentifier.class);
    private Optional<PrivateKey> key;
    private Cipher cipher;

    public Reidentifier(String string) {
        this.key = CryptoKey.getPrivateKey(string);
        try {
            this.cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            if (this.key.isPresent()) {
                this.cipher.init(2, this.key.get());
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            LOG.error("Could not init decryption", (Throwable)generalSecurityException);
        }
    }

    public void process(Attributes attributes) {
        Sequence sequence = attributes.getSequence(0x4000500);
        if (sequence != null && this.key.isPresent()) {
            byte[] byArray;
            Attributes attributes2 = (Attributes)sequence.get(0);
            try {
                byArray = attributes2.getBytes(67110176);
                byArray = this.cipher.doFinal(byArray);
            }
            catch (IOException | BadPaddingException | IllegalBlockSizeException exception) {
                LOG.error("Could not retrieve encoded data", (Throwable)exception);
                return;
            }
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (DicomInputStream dicomInputStream = new DicomInputStream((InputStream)new ByteArrayInputStream(byArray), attributes2.getString(67110160));){
                    Attributes attributes3 = dicomInputStream.readDataset(-1, -1);
                    attributes.addAll(attributes3);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                LOG.error("Could not retrieve encoded data", (Throwable)iOException);
            }
        }
    }
}

