/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.deidentify;

import com.agfa.hap.pacs.data.deidentify.PrivateTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SafePrivateTags {
    private static Map<String, Set<Integer>> safeTags = new HashMap<String, Set<Integer>>();

    static {
        SafePrivateTags.addTag(new PrivateTag(31522854, "ELSCINT1"));
        SafePrivateTags.addTag(new PrivateTag(0x1F10001, "ELSCINT1"));
        SafePrivateTags.addTag(new PrivateTag(1638558, "GEMS_ACQU_01"));
        SafePrivateTags.addTag(new PrivateTag(4390951, "GEMS_PARM_01"));
        SafePrivateTags.addTag(new PrivateTag(536936452, "Philips Imaging DD 001"));
        SafePrivateTags.addTag(new PrivateTag(1638413, "SIEMENS MR HEADER"));
        SafePrivateTags.addTag(new PrivateTag(2424839, "GEMS_SERS_01"));
        SafePrivateTags.addTag(new PrivateTag(2113994754, "HOLOGIC, Inc."));
        SafePrivateTags.addTag(new PrivateTag(2113994770, "HOLOGIC, Inc."));
        SafePrivateTags.addTag(new PrivateTag(0x990001, "NQHeader"));
        SafePrivateTags.addTag(new PrivateTag(0x990002, "NQHeader"));
        SafePrivateTags.addTag(new PrivateTag(0x990005, "NQHeader"));
        SafePrivateTags.addTag(new PrivateTag(0x990020, "NQHeader"));
    }

    static void addTag(PrivateTag privateTag) {
        safeTags.computeIfAbsent(privateTag.creator, string -> new HashSet()).add(privateTag.tag);
    }

    public static boolean isSafeTag(int n, String string) {
        if (string == null) {
            return false;
        }
        Set<Integer> set = safeTags.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(n & 0xFFFF00FF);
    }
}

