/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.dicom;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.dcm4che3.data.VR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataTypeForVR {
    STRING(String.class, VR.AE, VR.AS, VR.CS, VR.LO, VR.LT, VR.OB, VR.OW, VR.PN, VR.SH, VR.SQ, VR.ST, VR.UI, VR.UN, VR.UT),
    INTEGER(Integer.class, VR.IS, VR.SL, VR.SS, VR.UL, VR.US),
    FLOAT(Double.class, VR.DS, VR.FL, VR.FD, VR.OF),
    DATE(Date.class, VR.DA),
    TIME(Time.class, VR.TM),
    DATETIME(Date.class, VR.DT);

    private final Class<?> valueClass;
    private final VR[] valueRepresentations;
    private static final Map<VR, DataTypeForVR> VR_TO_DATATYPE_MAP;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(DataTypeForVR.class);
        VR_TO_DATATYPE_MAP = new EnumMap<VR, DataTypeForVR>(VR.class);
        DataTypeForVR[] dataTypeForVRArray = DataTypeForVR.values();
        int n = dataTypeForVRArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataTypeForVR dataTypeForVR = dataTypeForVRArray[n2];
            VR[] vRArray = dataTypeForVR.valueRepresentations;
            int n3 = dataTypeForVR.valueRepresentations.length;
            int n4 = 0;
            while (n4 < n3) {
                VR vR = vRArray[n4];
                if (VR_TO_DATATYPE_MAP.containsKey(vR)) {
                    throw new IllegalArgumentException("Each value representation can only be associated with one data type! VR: " + vR);
                }
                VR_TO_DATATYPE_MAP.put(vR, dataTypeForVR);
                ++n4;
            }
            ++n2;
        }
    }

    private DataTypeForVR(Class<?> clazz, VR ... vRArray) {
        this.valueClass = clazz;
        this.valueRepresentations = vRArray;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public static final DataTypeForVR getDataType(VR vR) {
        return VR_TO_DATATYPE_MAP.get(vR);
    }

    public static final DataTypeForVR getDataType(String string) {
        try {
            Field field = VR.class.getField(string);
            Object object = field.get(null);
            if (object instanceof VR) {
                return DataTypeForVR.getDataType((VR)object);
            }
        }
        catch (Exception exception) {
            log.warn("Cannot find VR object for: {}", (Object)string);
        }
        return null;
    }

    public class Time
    extends Date {
        private static final long serialVersionUID = 172241262274763636L;
    }
}

