/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.keyobject;

import com.agfa.hap.pacs.data.keyobject.content.Content;
import com.agfa.hap.pacs.data.keyobject.content.ContentTemplate;
import com.agfa.hap.pacs.data.keyobject.content.DocumentContent;
import com.agfa.hap.pacs.data.keyobject.content.SRReferencedImage;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class KeyObjectBuilder
implements DatasetSource {
    private static final ContentTemplate KEY_OBJECT_CONTENT_TEMPLATE = new ContentTemplate("2010", "DCMR");
    private final Attributes attributes;
    private final Sequence contentSequence;
    private final List<SOPInstanceReference> studyReferences;
    private String retrieveAET;

    public KeyObjectBuilder(Code code, Attributes attributes) {
        this(code, attributes, false);
    }

    public KeyObjectBuilder(Code code, Attributes attributes, boolean bl) {
        this.attributes = KeyObjectBuilder.initAttributes(code, attributes);
        this.retrieveAET = bl ? this.attributes.getString(524372) : null;
        this.attributes.remove(524372);
        this.contentSequence = this.attributes.newSequence(4237104, 10);
        this.studyReferences = new ArrayList<SOPInstanceReference>(1);
    }

    private static Attributes initAttributes(Code code, Attributes attributes) {
        Attributes attributes2 = new Attributes(attributes);
        Date date = new Date();
        attributes2.setString(524384, VR.CS, "KO");
        KeyObjectBuilder.setIfNotExists(attributes2, 0x20000E, VR.UI, UIDUtils.createUID());
        KeyObjectBuilder.setIfNotExists(attributes2, 524321, VR.DA, date);
        KeyObjectBuilder.setIfNotExists(attributes2, 524337, VR.TM, date);
        if (!attributes2.contains(0x200011)) {
            attributes2.setNull(0x200011, VR.IS);
        }
        KeyObjectBuilder.setIfNotExists(attributes2, 528446, VR.LO, "Flag [" + code.getCodeMeaning() + ']');
        attributes2.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        attributes2.setString(524312, VR.UI, UIDUtils.createUID());
        attributes2.setDate(2251877123620883L, date);
        attributes2.setInt(2097171, VR.IS, new int[]{1});
        attributes2.setDate(2251950138064947L, date);
        attributes2.setNull(528657, VR.SQ);
        attributes2.setString(0x40A040, VR.CS, ValueType.Container.dicom());
        Sequence sequence = attributes2.newSequence(4235331, 1);
        sequence.add(code.toDataset());
        attributes2.setString(4235344, VR.CS, ContinuityOfContent.Separate.dicom());
        Sequence sequence2 = attributes2.newSequence(4236548, 1);
        sequence2.add(KEY_OBJECT_CONTENT_TEMPLATE.toDataset());
        return attributes2;
    }

    private static void setIfNotExists(Attributes attributes, int n, VR vR, String string) {
        if (!attributes.containsValue(n)) {
            attributes.setString(n, vR, string);
        }
    }

    private static void setIfNotExists(Attributes attributes, int n, VR vR, Date date) {
        if (!attributes.containsValue(n)) {
            attributes.setDate(n, vR, new Date[]{date});
        }
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes(this.attributes);
        Sequence sequence = attributes.newSequence(4236149, this.studyReferences.size());
        for (SOPInstanceReference sOPInstanceReference : this.studyReferences) {
            sequence.add(sOPInstanceReference.toDataset());
        }
        return attributes;
    }

    public void insertReference(UIDType uIDType, String string, String string2, String string3, String string4, int[] nArray) {
        this.addToContentSequence(uIDType, string, string2, nArray);
        this.addToStudyReferences(string, string2, string3, string4);
    }

    private void addToContentSequence(UIDType uIDType, String string, String string2, int[] nArray) {
        DocumentContent documentContent;
        switch (uIDType) {
            case Image: {
                documentContent = new DocumentContent.ImageContent(new SRReferencedImage(string, string2, nArray));
                break;
            }
            case Waveform: {
                documentContent = new DocumentContent.WaveformContent(new ReferencedWaveform(string, string2, nArray));
                break;
            }
            case KeyObject: 
            case Composite: 
            case StructuredReport: 
            case Presentation: {
                documentContent = new DocumentContent.CompositeContent(new ReferencedSOP(string, string2));
                break;
            }
            default: {
                return;
            }
        }
        this.contentSequence.add(new Content(RelationshipType.Contains, documentContent, null).toDataset());
    }

    /*
     * WARNING - void declaration
     */
    private void addToStudyReferences(String string, String string2, String string3, String string4) {
        void var6_14;
        void var6_12;
        SOPInstanceReference sOPInstanceReference = null;
        for (SOPInstanceReference sOPInstanceReference2 : this.studyReferences) {
            if (!sOPInstanceReference2.getStudyInstanceUID().equals(string4)) continue;
            sOPInstanceReference = sOPInstanceReference2;
            break;
        }
        if (sOPInstanceReference == null) {
            sOPInstanceReference = new SOPInstanceReference(string4);
            this.studyReferences.add(sOPInstanceReference);
        }
        Object var6_10 = null;
        for (ReferencedSeries referencedSeries : sOPInstanceReference.referencedSeries()) {
            if (!referencedSeries.getSeriesInstanceUID().equals(string3)) continue;
            ReferencedSeries referencedSeries2 = referencedSeries;
            break;
        }
        if (var6_12 == null) {
            ReferencedSeries referencedSeries = new ReferencedSeries(string3);
            if (this.retrieveAET != null) {
                referencedSeries.setRetrieveAETs(new String[]{this.retrieveAET});
            }
            sOPInstanceReference.referencedSeries().add(referencedSeries);
        }
        var6_14.referencedSOP().add(new ReferencedSOP(string, string2));
    }
}

