/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.keyobject.content;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import org.dcm4che3.data.Attributes;

public class SRReferencedImage
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;
    private int[] referencedFrameNumber;
    private ReferencedSOP softcopyPresentationState;
    private ReferencedSOP realWorldValueMapping;

    private SRReferencedImage(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
        this.referencedFrameNumber = this.getIntegers(attributes, 528736);
        this.softcopyPresentationState = ReferencedSOP.create(attributes.getNestedDataset(528793));
        this.realWorldValueMapping = ReferencedSOP.create(attributes.getNestedDataset(528715));
    }

    public SRReferencedImage(String string, String string2, int[] nArray) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
        this.referencedFrameNumber = SRReferencedImage.copyArray(nArray);
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        this.set(this.referencedFrameNumber, attributes, 528736, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.softcopyPresentationState, attributes, 528793, DatasetAccessor.Type.Optional);
        this.set(this.realWorldValueMapping, attributes, 528715, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static SRReferencedImage create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new SRReferencedImage(attributes);
        }
        return null;
    }

    public int[] getReferencedFrameNumbers() {
        return SRReferencedImage.copyArray(this.referencedFrameNumber);
    }

    public ReferencedSOP getSoftcopyPresentationState() {
        return this.softcopyPresentationState;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }
}

